/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.core.ResolvableType;
import org.springframework.kafka.support.JacksonUtils;
import org.springframework.kafka.support.converter.AbstractJavaTypeMapper;
import org.springframework.kafka.support.converter.DefaultJackson2JavaTypeMapper;
import org.springframework.kafka.support.converter.Jackson2JavaTypeMapper;
import org.springframework.kafka.support.serializer.JsonSerializer;
import org.springframework.kafka.support.serializer.JsonTypeResolver;
import org.springframework.kafka.support.serializer.SerializationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class JsonDeserializer<T>
implements Deserializer<T> {
    private static final String KEY_DEFAULT_TYPE_STRING = "spring.json.key.default.type";
    public static final String KEY_DEFAULT_TYPE = "spring.json.key.default.type";
    public static final String VALUE_DEFAULT_TYPE = "spring.json.value.default.type";
    public static final String TRUSTED_PACKAGES = "spring.json.trusted.packages";
    public static final String TYPE_MAPPINGS = "spring.json.type.mapping";
    public static final String REMOVE_TYPE_INFO_HEADERS = "spring.json.remove.type.headers";
    public static final String USE_TYPE_INFO_HEADERS = "spring.json.use.type.headers";
    public static final String KEY_TYPE_METHOD = "spring.json.key.type.method";
    public static final String VALUE_TYPE_METHOD = "spring.json.value.type.method";
    protected final ObjectMapper objectMapper;
    protected JavaType targetType;
    protected Jackson2JavaTypeMapper typeMapper = new DefaultJackson2JavaTypeMapper();
    private ObjectReader reader;
    private boolean typeMapperExplicitlySet = false;
    private boolean removeTypeHeaders = true;
    private boolean useTypeHeaders = true;
    private JsonTypeResolver typeResolver;

    public JsonDeserializer() {
        this((Class)null, true);
    }

    public JsonDeserializer(ObjectMapper objectMapper) {
        this((Class)null, objectMapper, true);
    }

    public JsonDeserializer(@Nullable Class<? super T> targetType) {
        this(targetType, true);
    }

    public JsonDeserializer(@Nullable TypeReference<? super T> targetType) {
        this(targetType, true);
    }

    public JsonDeserializer(@Nullable JavaType targetType) {
        this(targetType, true);
    }

    public JsonDeserializer(@Nullable Class<? super T> targetType, boolean useHeadersIfPresent) {
        this(targetType, JacksonUtils.enhancedObjectMapper(), useHeadersIfPresent);
    }

    public JsonDeserializer(TypeReference<? super T> targetType, boolean useHeadersIfPresent) {
        this(targetType, JacksonUtils.enhancedObjectMapper(), useHeadersIfPresent);
    }

    public JsonDeserializer(JavaType targetType, boolean useHeadersIfPresent) {
        this(targetType, JacksonUtils.enhancedObjectMapper(), useHeadersIfPresent);
    }

    public JsonDeserializer(Class<? super T> targetType, ObjectMapper objectMapper) {
        this(targetType, objectMapper, true);
    }

    public JsonDeserializer(TypeReference<? super T> targetType, ObjectMapper objectMapper) {
        this(targetType, objectMapper, true);
    }

    public JsonDeserializer(JavaType targetType, ObjectMapper objectMapper) {
        this(targetType, objectMapper, true);
    }

    public JsonDeserializer(@Nullable Class<? super T> targetType, ObjectMapper objectMapper, boolean useHeadersIfPresent) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null.");
        this.objectMapper = objectMapper;
        JavaType javaType = null;
        if (targetType == null) {
            Class genericType = ResolvableType.forClass(this.getClass()).getSuperType().resolveGeneric(new int[]{0});
            if (genericType != null) {
                javaType = TypeFactory.defaultInstance().constructType((Type)genericType);
            }
        } else {
            javaType = TypeFactory.defaultInstance().constructType(targetType);
        }
        this.initialize(javaType, useHeadersIfPresent);
    }

    public JsonDeserializer(TypeReference<? super T> targetType, ObjectMapper objectMapper, boolean useHeadersIfPresent) {
        this(targetType != null ? TypeFactory.defaultInstance().constructType(targetType) : null, objectMapper, useHeadersIfPresent);
    }

    public JsonDeserializer(@Nullable JavaType targetType, ObjectMapper objectMapper, boolean useHeadersIfPresent) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null.");
        this.objectMapper = objectMapper;
        this.initialize(targetType, useHeadersIfPresent);
    }

    public Jackson2JavaTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public void setTypeMapper(Jackson2JavaTypeMapper typeMapper) {
        Assert.notNull((Object)typeMapper, (String)"'typeMapper' cannot be null");
        this.typeMapper = typeMapper;
        this.typeMapperExplicitlySet = true;
        if (typeMapper instanceof AbstractJavaTypeMapper) {
            this.addMappingsToTrusted(((AbstractJavaTypeMapper)((Object)typeMapper)).getIdClassMapping());
        }
    }

    public void setUseTypeMapperForKey(boolean isKey) {
        if (!this.typeMapperExplicitlySet && this.getTypeMapper() instanceof AbstractJavaTypeMapper) {
            ((AbstractJavaTypeMapper)((Object)this.getTypeMapper())).setUseForKey(isKey);
        }
    }

    public void setRemoveTypeHeaders(boolean removeTypeHeaders) {
        this.removeTypeHeaders = removeTypeHeaders;
    }

    public void setUseTypeHeaders(boolean useTypeHeaders) {
        if (!this.typeMapperExplicitlySet) {
            this.useTypeHeaders = useTypeHeaders;
            this.setUpTypePrecedence(Collections.emptyMap());
        }
    }

    public void setTypeFunction(BiFunction<byte[], Headers, JavaType> typeFunction) {
        this.typeResolver = (topic, data, headers) -> (JavaType)typeFunction.apply(data, headers);
    }

    public void setTypeResolver(JsonTypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.setUseTypeMapperForKey(isKey);
        this.setUpTypePrecedence(configs);
        this.setupTarget(configs, isKey);
        if (configs.containsKey(TRUSTED_PACKAGES) && configs.get(TRUSTED_PACKAGES) instanceof String) {
            this.typeMapper.addTrustedPackages(StringUtils.delimitedListToStringArray((String)((String)configs.get(TRUSTED_PACKAGES)), (String)",", (String)" \r\n\f\t"));
        }
        if (configs.containsKey(TYPE_MAPPINGS) && !this.typeMapperExplicitlySet && this.typeMapper instanceof AbstractJavaTypeMapper) {
            ((AbstractJavaTypeMapper)((Object)this.typeMapper)).setIdClassMapping(this.createMappings(configs));
        }
        if (configs.containsKey(REMOVE_TYPE_INFO_HEADERS)) {
            this.removeTypeHeaders = Boolean.parseBoolean(configs.get(REMOVE_TYPE_INFO_HEADERS).toString());
        }
        this.setUpTypeMethod(configs, isKey);
    }

    private Map<String, Class<?>> createMappings(Map<String, ?> configs) {
        Map<String, Class<?>> mappings = JsonSerializer.createMappings(configs.get(TYPE_MAPPINGS).toString());
        this.addMappingsToTrusted(mappings);
        return mappings;
    }

    private void setUpTypeMethod(Map<String, ?> configs, boolean isKey) {
        if (isKey && configs.containsKey(KEY_TYPE_METHOD)) {
            this.setUpTypeResolver((String)configs.get(KEY_TYPE_METHOD));
        } else if (!isKey && configs.containsKey(VALUE_TYPE_METHOD)) {
            this.setUpTypeResolver((String)configs.get(VALUE_TYPE_METHOD));
        }
    }

    private void setUpTypeResolver(String method) {
        try {
            this.typeResolver = this.buildTypeResolver(method);
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof NoSuchMethodException) {
                this.typeResolver = (topic, data, headers) -> (JavaType)SerializationUtils.propertyToMethodInvokingFunction(method, byte[].class, this.getClass().getClassLoader()).apply(data, headers);
                return;
            }
            throw e;
        }
    }

    private void setUpTypePrecedence(Map<String, ?> configs) {
        if (!this.typeMapperExplicitlySet) {
            if (configs.containsKey(USE_TYPE_INFO_HEADERS)) {
                this.useTypeHeaders = Boolean.parseBoolean(configs.get(USE_TYPE_INFO_HEADERS).toString());
            }
            this.typeMapper.setTypePrecedence(this.useTypeHeaders ? Jackson2JavaTypeMapper.TypePrecedence.TYPE_ID : Jackson2JavaTypeMapper.TypePrecedence.INFERRED);
        }
    }

    private void setupTarget(Map<String, ?> configs, boolean isKey) {
        try {
            JavaType javaType = null;
            if (isKey && configs.containsKey("spring.json.key.default.type")) {
                javaType = this.setupTargetType(configs, "spring.json.key.default.type");
            } else if (!isKey && configs.containsKey(VALUE_DEFAULT_TYPE)) {
                javaType = this.setupTargetType(configs, VALUE_DEFAULT_TYPE);
            }
            if (javaType != null) {
                this.initialize(javaType, Jackson2JavaTypeMapper.TypePrecedence.TYPE_ID.equals((Object)this.typeMapper.getTypePrecedence()));
            }
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new IllegalStateException(e);
        }
    }

    private void initialize(@Nullable JavaType type, boolean useHeadersIfPresent) {
        this.targetType = type;
        Assert.isTrue((this.targetType != null || useHeadersIfPresent ? 1 : 0) != 0, (String)"'targetType' cannot be null if 'useHeadersIfPresent' is false");
        if (this.targetType != null) {
            this.reader = this.objectMapper.readerFor(this.targetType);
        }
        this.addTargetPackageToTrusted();
        this.typeMapper.setTypePrecedence(useHeadersIfPresent ? Jackson2JavaTypeMapper.TypePrecedence.TYPE_ID : Jackson2JavaTypeMapper.TypePrecedence.INFERRED);
    }

    private JavaType setupTargetType(Map<String, ?> configs, String key) throws ClassNotFoundException, LinkageError {
        if (configs.get(key) instanceof Class) {
            return TypeFactory.defaultInstance().constructType((Type)((Class)configs.get(key)));
        }
        if (configs.get(key) instanceof String) {
            return TypeFactory.defaultInstance().constructType((Type)ClassUtils.forName((String)((String)configs.get(key)), null));
        }
        throw new IllegalStateException(key + " must be Class or String");
    }

    public void addTrustedPackages(String ... packages) {
        this.doAddTrustedPackages(packages);
    }

    private void addMappingsToTrusted(Map<String, Class<?>> mappings) {
        mappings.values().forEach(clazz -> {
            this.doAddTrustedPackages(clazz.getPackage().getName());
            this.doAddTrustedPackages(clazz.getPackage().getName() + ".*");
        });
    }

    private void addTargetPackageToTrusted() {
        String targetPackageName = this.getTargetPackageName();
        if (targetPackageName != null) {
            this.doAddTrustedPackages(targetPackageName);
            this.doAddTrustedPackages(targetPackageName + ".*");
        }
    }

    private String getTargetPackageName() {
        if (this.targetType != null) {
            return ClassUtils.getPackageName((Class)this.targetType.getRawClass()).replaceFirst("\\[L", "");
        }
        return null;
    }

    private void doAddTrustedPackages(String ... packages) {
        this.typeMapper.addTrustedPackages(packages);
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        if (data == null) {
            return null;
        }
        ObjectReader deserReader = null;
        JavaType javaType = null;
        if (this.typeResolver != null) {
            javaType = this.typeResolver.resolveType(topic, data, headers);
        }
        if (javaType == null && this.typeMapper.getTypePrecedence().equals((Object)Jackson2JavaTypeMapper.TypePrecedence.TYPE_ID)) {
            javaType = this.typeMapper.toJavaType(headers);
        }
        if (javaType != null) {
            deserReader = this.objectMapper.readerFor(javaType);
        }
        if (this.removeTypeHeaders) {
            this.typeMapper.removeHeaders(headers);
        }
        if (deserReader == null) {
            deserReader = this.reader;
        }
        Assert.state((deserReader != null ? 1 : 0) != 0, (String)"No type information in headers and no default type provided");
        try {
            return (T)deserReader.readValue(data);
        }
        catch (IOException e) {
            throw new SerializationException("Can't deserialize data [" + Arrays.toString(data) + "] from topic [" + topic + "]", (Throwable)e);
        }
    }

    public T deserialize(String topic, @Nullable byte[] data) {
        JavaType javaType;
        if (data == null) {
            return null;
        }
        ObjectReader localReader = this.reader;
        if (this.typeResolver != null && (javaType = this.typeResolver.resolveType(topic, data, null)) != null) {
            localReader = this.objectMapper.readerFor(javaType);
        }
        Assert.state((localReader != null ? 1 : 0) != 0, (String)"No headers available and no default type provided");
        try {
            return (T)localReader.readValue(data);
        }
        catch (IOException e) {
            throw new SerializationException("Can't deserialize data [" + Arrays.toString(data) + "] from topic [" + topic + "]", (Throwable)e);
        }
    }

    public void close() {
    }

    public <X> JsonDeserializer<X> copyWithType(Class<? super X> newTargetType) {
        return this.copyWithType(this.objectMapper.constructType(newTargetType));
    }

    public <X> JsonDeserializer<X> copyWithType(TypeReference<? super X> newTargetType) {
        return this.copyWithType(this.objectMapper.constructType(newTargetType.getType()));
    }

    public <X> JsonDeserializer<X> copyWithType(JavaType newTargetType) {
        JsonDeserializer<T> result = new JsonDeserializer<T>(newTargetType, this.objectMapper, this.useTypeHeaders);
        result.removeTypeHeaders = this.removeTypeHeaders;
        result.typeMapper = this.typeMapper;
        result.typeMapperExplicitlySet = this.typeMapperExplicitlySet;
        return result;
    }

    public JsonDeserializer<T> forKeys() {
        this.setUseTypeMapperForKey(true);
        return this;
    }

    public JsonDeserializer<T> dontRemoveTypeHeaders() {
        this.setRemoveTypeHeaders(false);
        return this;
    }

    public JsonDeserializer<T> ignoreTypeHeaders() {
        this.setUseTypeHeaders(false);
        return this;
    }

    public JsonDeserializer<T> typeMapper(Jackson2JavaTypeMapper mapper) {
        this.setTypeMapper(mapper);
        return this;
    }

    public JsonDeserializer<T> trustedPackages(String ... packages) {
        Assert.isTrue((!this.typeMapperExplicitlySet ? 1 : 0) != 0, (String)"When using a custom type mapper, set the trusted packages there");
        this.typeMapper.addTrustedPackages(packages);
        return this;
    }

    public JsonDeserializer<T> typeFunction(BiFunction<byte[], Headers, JavaType> typeFunction) {
        this.setTypeFunction(typeFunction);
        return this;
    }

    public JsonDeserializer<T> typeResolver(JsonTypeResolver resolver) {
        this.setTypeResolver(resolver);
        return this;
    }

    private JsonTypeResolver buildTypeResolver(String methodProperty) {
        Method method;
        Class clazz;
        int lastDotPosn = methodProperty.lastIndexOf(46);
        Assert.state((lastDotPosn > 1 ? 1 : 0) != 0, (String)"the method property needs to be a class name followed by the method name, separated by '.'");
        try {
            clazz = ClassUtils.forName((String)methodProperty.substring(0, lastDotPosn), (ClassLoader)this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new IllegalStateException(e);
        }
        String methodName = methodProperty.substring(lastDotPosn + 1);
        try {
            method = clazz.getDeclaredMethod(methodName, String.class, byte[].class, Headers.class);
            Assert.state((boolean)JavaType.class.isAssignableFrom(method.getReturnType()), (String)(method + " return type must be JavaType"));
            Assert.state((boolean)Modifier.isStatic(method.getModifiers()), (String)(method + " must be static"));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(e);
        }
        return (topic, data, headers) -> {
            try {
                return (JavaType)method.invoke(null, topic, data, headers);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        };
    }
}

