/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.kafka.support.JacksonUtils;
import org.springframework.kafka.support.mapping.AbstractJavaTypeMapper;
import org.springframework.kafka.support.mapping.DefaultJackson2JavaTypeMapper;
import org.springframework.kafka.support.mapping.Jackson2JavaTypeMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class JsonSerializer<T>
implements Serializer<T> {
    public static final String ADD_TYPE_INFO_HEADERS = "spring.json.add.type.headers";
    public static final String TYPE_MAPPINGS = "spring.json.type.mapping";
    protected final ObjectMapper objectMapper;
    protected boolean addTypeInfo = true;
    private ObjectWriter writer;
    protected Jackson2JavaTypeMapper typeMapper = new DefaultJackson2JavaTypeMapper();
    private boolean typeMapperExplicitlySet = false;
    private boolean setterCalled;
    private boolean configured;

    public JsonSerializer() {
        this((JavaType)null, JacksonUtils.enhancedObjectMapper());
    }

    public JsonSerializer(TypeReference<? super T> targetType) {
        this(targetType, JacksonUtils.enhancedObjectMapper());
    }

    public JsonSerializer(ObjectMapper objectMapper) {
        this((JavaType)null, objectMapper);
    }

    public JsonSerializer(TypeReference<? super T> targetType, ObjectMapper objectMapper) {
        this(targetType == null ? null : objectMapper.constructType(targetType.getType()), objectMapper);
    }

    public JsonSerializer(JavaType targetType, ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null.");
        this.objectMapper = objectMapper;
        this.writer = objectMapper.writerFor(targetType);
    }

    public boolean isAddTypeInfo() {
        return this.addTypeInfo;
    }

    public void setAddTypeInfo(boolean addTypeInfo) {
        this.addTypeInfo = addTypeInfo;
        this.setterCalled = true;
    }

    public Jackson2JavaTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public void setTypeMapper(Jackson2JavaTypeMapper typeMapper) {
        Assert.notNull((Object)typeMapper, (String)"'typeMapper' cannot be null");
        this.typeMapper = typeMapper;
        this.typeMapperExplicitlySet = true;
        this.setterCalled = true;
    }

    public void setUseTypeMapperForKey(boolean isKey) {
        if (!this.typeMapperExplicitlySet && this.getTypeMapper() instanceof AbstractJavaTypeMapper) {
            ((AbstractJavaTypeMapper)((Object)this.getTypeMapper())).setUseForKey(isKey);
        }
        this.setterCalled = true;
    }

    public synchronized void configure(Map<String, ?> configs, boolean isKey) {
        Jackson2JavaTypeMapper jackson2JavaTypeMapper;
        if (this.configured) {
            return;
        }
        Assert.state((!this.setterCalled || !configs.containsKey(ADD_TYPE_INFO_HEADERS) && !configs.containsKey(TYPE_MAPPINGS) ? 1 : 0) != 0, (String)"JsonSerializer must be configured with property setters, or via configuration properties; not both");
        this.setUseTypeMapperForKey(isKey);
        if (configs.containsKey(ADD_TYPE_INFO_HEADERS)) {
            Object config = configs.get(ADD_TYPE_INFO_HEADERS);
            if (config instanceof Boolean) {
                Boolean configBoolean = (Boolean)config;
                this.addTypeInfo = configBoolean;
            } else if (config instanceof String) {
                String configString = (String)config;
                this.addTypeInfo = Boolean.parseBoolean(configString);
            } else {
                throw new IllegalStateException("spring.json.add.type.headers must be Boolean or String");
            }
        }
        if (configs.containsKey(TYPE_MAPPINGS) && !this.typeMapperExplicitlySet && (jackson2JavaTypeMapper = this.typeMapper) instanceof AbstractJavaTypeMapper) {
            AbstractJavaTypeMapper abstractJavaTypeMapper = (AbstractJavaTypeMapper)((Object)jackson2JavaTypeMapper);
            abstractJavaTypeMapper.setIdClassMapping(JsonSerializer.createMappings((String)configs.get(TYPE_MAPPINGS)));
        }
        this.configured = true;
    }

    protected static Map<String, Class<?>> createMappings(String mappings) {
        String[] array;
        HashMap mappingsMap = new HashMap();
        for (String entry : array = StringUtils.commaDelimitedListToStringArray((String)mappings)) {
            String[] split = entry.split(":");
            Assert.isTrue((split.length == 2 ? 1 : 0) != 0, (String)"Each comma-delimited mapping entry must have exactly one ':'");
            try {
                mappingsMap.put(split[0].trim(), ClassUtils.forName((String)split[1].trim(), (ClassLoader)ClassUtils.getDefaultClassLoader()));
            }
            catch (ClassNotFoundException | LinkageError e) {
                throw new IllegalArgumentException("Failed to load: " + split[1] + " for " + split[0], e);
            }
        }
        return mappingsMap;
    }

    @Nullable
    public byte[] serialize(String topic, Headers headers, @Nullable T data) {
        if (data == null) {
            return null;
        }
        if (this.addTypeInfo && headers != null) {
            this.typeMapper.fromJavaType(this.objectMapper.constructType(data.getClass()), headers);
        }
        return this.serialize(topic, data);
    }

    @Nullable
    public byte[] serialize(String topic, @Nullable T data) {
        if (data == null) {
            return null;
        }
        try {
            return this.writer.writeValueAsBytes(data);
        }
        catch (IOException ex) {
            throw new SerializationException("Can't serialize data [" + data + "] for topic [" + topic + "]", (Throwable)ex);
        }
    }

    public void close() {
    }

    public <X> JsonSerializer<X> copyWithType(Class<? super X> newTargetType) {
        return this.copyWithType(this.objectMapper.constructType(newTargetType));
    }

    public <X> JsonSerializer<X> copyWithType(TypeReference<? super X> newTargetType) {
        return this.copyWithType(this.objectMapper.constructType(newTargetType.getType()));
    }

    public <X> JsonSerializer<X> copyWithType(JavaType newTargetType) {
        JsonSerializer<T> result = new JsonSerializer<T>(newTargetType, this.objectMapper);
        result.addTypeInfo = this.addTypeInfo;
        result.typeMapper = this.typeMapper;
        result.typeMapperExplicitlySet = this.typeMapperExplicitlySet;
        return result;
    }

    public JsonSerializer<T> forKeys() {
        this.setUseTypeMapperForKey(true);
        return this;
    }

    public JsonSerializer<T> noTypeInfo() {
        this.setAddTypeInfo(false);
        return this;
    }

    public JsonSerializer<T> typeMapper(Jackson2JavaTypeMapper mapper) {
        this.setTypeMapper(mapper);
        return this;
    }
}

