/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantPoolChecker {
    private static final boolean DEBUG = false;
    private static final byte CONSTANT_Utf8 = 1;
    private static final byte CONSTANT_Integer = 3;
    private static final byte CONSTANT_Float = 4;
    private static final byte CONSTANT_Long = 5;
    private static final byte CONSTANT_Double = 6;
    private static final byte CONSTANT_Class = 7;
    private static final byte CONSTANT_String = 8;
    private static final byte CONSTANT_Fieldref = 9;
    private static final byte CONSTANT_Methodref = 10;
    private static final byte CONSTANT_InterfaceMethodref = 11;
    private static final byte CONSTANT_NameAndType = 12;
    private Object[] cpdata;
    private int cpsize;
    private int[] type;
    private List<String> referencedClasses = new ArrayList<String>();

    public static void main(String[] args) throws Exception {
    }

    static List<String> getReferencedClasses(byte[] bytes) {
        return new ConstantPoolChecker((byte[])bytes).referencedClasses;
    }

    private ConstantPoolChecker(byte[] bytes) {
        this.readConstantPool(bytes);
        this.computeReferences();
    }

    public void computeReferences() {
        for (int i = 0; i < this.cpsize; ++i) {
            switch (this.type[i]) {
                case 7: {
                    int classindex = (Integer)this.cpdata[i];
                    String classname = (String)this.cpdata[classindex];
                    if (classname == null) {
                        throw new IllegalStateException();
                    }
                    this.referencedClasses.add(classname);
                }
            }
        }
    }

    public void readConstantPool(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            DataInputStream dis = new DataInputStream(bais);
            int magic = dis.readInt();
            if (magic != -889275714) {
                throw new IllegalStateException("not bytecode, magic was 0x" + Integer.toString(magic, 16));
            }
            dis.skip(4L);
            this.cpsize = dis.readShort();
            this.cpdata = new Object[this.cpsize];
            this.type = new int[this.cpsize];
            for (int cpentry = 1; cpentry < this.cpsize; ++cpentry) {
                boolean doubleSlot = this.processConstantPoolEntry(cpentry, dis);
                if (!doubleSlot) continue;
                ++cpentry;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected problem processing bytes for class", e);
        }
    }

    private boolean processConstantPoolEntry(int index, DataInputStream dis) throws IOException {
        byte b = dis.readByte();
        this.type[index] = b;
        switch (b) {
            case 1: {
                this.cpdata[index] = dis.readUTF();
                break;
            }
            case 3: {
                dis.skip(4L);
                break;
            }
            case 4: {
                dis.skip(4L);
                break;
            }
            case 5: {
                dis.skip(8L);
                return true;
            }
            case 6: {
                dis.skip(8L);
                return true;
            }
            case 7: {
                this.cpdata[index] = (int)dis.readShort();
                break;
            }
            case 8: {
                dis.skip(2L);
                break;
            }
            case 9: {
                dis.skip(4L);
                break;
            }
            case 10: {
                dis.skip(4L);
                break;
            }
            case 11: {
                dis.skip(4L);
                break;
            }
            case 12: {
                dis.skip(4L);
                break;
            }
            default: {
                throw new IllegalStateException("Entry: " + index + " " + Byte.toString(b));
            }
        }
        return false;
    }
}

