package com.simm.exhibitor.bean.basic;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;

import lombok.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
* Created by Mybatis Generator on 2022/12/15 09:33
 * @author admin
 */

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
@EqualsAndHashCode(callSuper = true)
public class HallAreaDivide extends BaseBean {
    @ApiModelProperty("")
    private Integer id;

    @ApiModelProperty("分类名称")
    @NotBlank(message = "名称不能为空")
    private String name;

    @ApiModelProperty("展馆id")
    @NotBlank(message = "展馆不能为空")
    private String boothId;

    @ApiModelProperty("1:zh-CN 2:en-US")
    private Integer type;

    @ApiModelProperty("英文名称")
    @NotBlank(message = "英文名称不能为空")
    private String nameEn;

    @ApiModelProperty("年份")
    @NotNull(message = "年份不能为空")
    private Integer year;

    @ApiModelProperty("")
    private Integer status;

    @ApiModelProperty("排序")
    private Integer sort;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新人")
    private String lastUpdateBy;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;
}