package com.simm.exhibitor.bean.exhibitors;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
* Created by Mybatis Generator on 2019/12/10 14:17
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebPassTicketTotal extends BaseBean {
    @ApiModelProperty("")
    private Integer id;

    @ApiModelProperty("展商唯一id")
    private String exhibitorUniqueId;

    @ApiModelProperty("合同公司名")
    private String agreementName;

    @ApiModelProperty("展馆号")
    private String boothId;

    @ApiModelProperty("展位号")
    private String boothNo;

    @ApiModelProperty("展位面积")
    private String boothArea;

    @ApiModelProperty("展位费缴费情况（0：未缴清，1：已缴清）")
    private Integer boothCost;

    @ApiModelProperty("水电费缴费情况（0：未缴清，1：已缴清）")
    private Integer exhibitorCost;

    @ApiModelProperty("展商证标准数量")
    private Integer standardNumber;

    @ApiModelProperty("已申领数量")
    private Integer claimedNumber;

    @ApiModelProperty("制证数量")
    private Integer accreditationNumber;

    @ApiModelProperty("已领取数量")
    private Integer receiveNumber;

    @ApiModelProperty("已缴费数量")
    private Integer costNumber;

    @ApiModelProperty("未缴费数量")
    private Integer unCostNumber;

    @ApiModelProperty("签到时间")
    private Date signTime;

    @ApiModelProperty("签到人")
    private String signPerson;

    @ApiModelProperty("签到手机号码")
    private String signMobile;

    @ApiModelProperty("领取人")
    private String receivePerson;

    @ApiModelProperty("担保情况（0：否，1：是）")
    private Integer isGuarantee;

    @ApiModelProperty("届数")
    private Integer number;

    @ApiModelProperty("")
    private Integer status;

    @ApiModelProperty("")
    private Integer createById;

    @ApiModelProperty("")
    private String createBy;

    @ApiModelProperty("")
    private Date createTime;

    @ApiModelProperty("")
    private String lastUpdateBy;

    @ApiModelProperty("")
    private Date lastUpdateTime;

    @ApiModelProperty("")
    private String remark;

    //冗余
    private Integer count;

    @ApiModelProperty("1:总计，2：今日签到数")
    private Integer type;

    @ApiModelProperty("是否临时账号，默认为否")
    private Boolean tmpFlag;

    @ApiModelProperty("防疫承诺书url")
    private String epidemicPreventionUrl;

    @ApiModelProperty("今日是否申报人员信息")
    private Boolean todayApplyFlag;
}