package com.simm.exhibitor.bean.reservation;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
* Created by Mybatis Generator on 2021/07/14 16:06
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebServiceOrder extends BaseBean {
    @ApiModelProperty("主键id")
    private Integer id;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("展位号")
    private String boothNo;

    @ApiModelProperty("展商唯一id")
    private String exhibitorUniqueId;

    @ApiModelProperty("合同公司名")
    private String agreementExhibitName;

    @ApiModelProperty("订单来源")
    private String source;

    @ApiModelProperty("合同编号")
    private String agreementNo;

    @ApiModelProperty("合同url")
    private String agreementUrl;

    @ApiModelProperty("回传合同url")
    private String agreementUrlCallback;

    @ApiModelProperty("订单内容（json）")
    private String orderContent;

    @ApiModelProperty("总价（分）")
    private Integer totalPrice;

    @ApiModelProperty("已付金额(单位:分)")
    private Integer paidAmount;

    @ApiModelProperty("未付金额(单位:分)")
    private Integer unpaidAmount;

    @ApiModelProperty("已开票金额(单位:分)")
    private Integer openInvoiceAmount;

    @ApiModelProperty("订单状态(1：订单提交，2：回传合同，3：款项认领，4：交易完成)")
    private Integer orderStatus;

    @ApiModelProperty("业务状态(1:未付款,2:已付部分,3:订单完成)")
    private Integer serviceStatus;

    @ApiModelProperty("开票申请(1:未申请,2:新申请,3:已申请)")
    private Integer invoiceApply;

    @ApiModelProperty("搭建商公司名")
    private String exhibitorProduceCompany;

    @ApiModelProperty("搭建商联系人")
    private String exhibitorProduceName;

    @ApiModelProperty("搭建商手机联系人号码")
    private String exhibitorProduceMobile;

    @ApiModelProperty("附件url")
    private String attachmentUrl;

    @ApiModelProperty("电子签名url")
    private String signatureUrl;

    @ApiModelProperty("是否担保（0：否，1：是））")
    private Integer isGuarantee;

    @ApiModelProperty("担保类型：0 未担保 1 展商承担 2 主办方承担 3 展商和主办放共同承担")
    private Integer guaranteeType;

    @ApiModelProperty("展商担保金额")
    private Integer exhibitorGuaranteeAmount;

    @ApiModelProperty("主办方担保金额")
    private Integer sponsorGuaranteeAmount;

    @ApiModelProperty("状态（0：删除，1：正常，2：隐藏，3：作废）")
    private Integer status;

    @ApiModelProperty("导出批次")
    private String batchNo;

    @ApiModelProperty("发票公司名称")
    private String invoiceBusinessName;

    @ApiModelProperty("税号")
    private String taxNo;

    @ApiModelProperty("催开发票")
    private Integer urgentInvoice;

    private Integer openInvoice;

    private String cancelReason;

    private Integer year;

    //冗余字段
    private List<String> uniqueIds;

    @ApiModelProperty("展馆")
    private String boothId;

    @ApiModelProperty("展位面积(单位:平方米)")
    private Double boothArea;

    @ApiModelProperty("展位类型(1:标摊,2:光地)")
    private Integer boothType;

    @ApiModelProperty("合同实际总金额")
    private Long wholeAgreementAmount;

    @ApiModelProperty("已付总金额")
    private Long wholePaidAmount;

    @ApiModelProperty("未付总金额")
    private Long wholeUnpaidAmount;

    @ApiModelProperty("业务状态(1:未付款,2:已付部分,3:订单完成)")
    private List<Integer> serviceStatuss;

    private Integer exhibitorBaseinfoId;

    private List<SmebServiceOrderDetail> orderDetails;

}