package com.simm.exhibitor.bean.shipment;

import com.simm.common.bean.BaseBean;
import java.util.Date;

import lombok.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
* Created by Mybatis Generator on 2024/07/31 11:35
*/
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ShipmentReviewDiscount extends BaseBean {
    /**
     * id
     */
    private Integer id;

    /**
     * 展商id
     */
    @NotBlank(message = "展商uniqueId不能为空")
    private String uniqueId;

    /**
     * 优惠类型
     */
    @NotBlank(message = "优惠类型不能为空")
    private String type;

    /**
     * 优惠金额
     */
    @NotNull(message = "优惠金额不能为空")
    private Integer discountAmount;

    /**
     * 优惠来源  1主办方 2承运方
     */
    private Integer source;

    /**
     * 优惠描述
     */
    private String description;

    /**
     * 订单id
     */
    private Integer orderId;

    /**
     * 申报折扣id
     */
    private Integer declareDiscountId;

    /**
     * 创建时间
     */
    private Date createTime;
}