package com.simm.exhibitor.dto.exhibitor;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author liutao
 * @since 2023/9/27
 */
@Data
public class PassTicketUploadExcelDTO {

    @NotBlank(message = "公司名称不能为空")
    @ExcelProperty("*展商证公司名")
    private String businessName;

    @NotBlank(message = "展位号不能为空")
    @ExcelProperty("*展位号")
    private String boothNo;

    @NotBlank(message = "姓名不能为空")
    @ExcelProperty("*姓名")
    private String name;

    @NotBlank(message = "手机号不能为空")
    @ExcelProperty("*手机号")
    private String phone;

    @NotBlank(message = "邮箱不能为空")
    @ExcelProperty("*邮箱")
    private String email;

    @ExcelProperty("*身份证")
    private String identityCard;

    @NotBlank(message = "部门不能为空")
    @ExcelProperty("*部门")
    private String department;

    @NotBlank(message = "职位不能为空")
    @ExcelProperty("*职位")
    private String position;

    @ExcelProperty("港澳台及海外展商")
    private String isAbroadStr;

    @ExcelProperty("行号")
    private Integer index;

    private String errorMsg;
}
