package com.simm.exhibitor.dubbo.shipment;

import com.simm.exhibitor.bean.shipment.ShipmentDeclare;
import com.simm.exhibitor.vo.shipment.ShipmentDeclareVO;

/**
 * @author liutao
 * @since 2024/8/6
 */
public interface ShipmentDeclareDubboService {


    /**
     * 根据唯一id查询承运申报信息
     * @param uniqueId  uniqueId
     * @return {@link ShipmentDeclareVO}
     */
    ShipmentDeclareVO findDeclareDetailByUniqueId(String uniqueId);

    /**
     * 更新承运申报信息
     * @param shipmentDeclare {@link ShipmentDeclare}
     */
    void updateShipmentDeclare(ShipmentDeclare shipmentDeclare);

    /**
     * 根据唯一id查询承运申报信息
     * @param uniqueId  uniqueId
     * @return {@link ShipmentDeclare}
     */
    ShipmentDeclare findByUniqueId(String uniqueId);
}
