package com.simm.exhibitor.export;

import com.github.pagehelper.PageInfo;
import com.simm.exhibitor.bean.exhibitors.SmebPassTicketTotal;
import com.simm.exhibitor.dto.exhibitor.SmebPassTicketCountInfoDTO;
import com.simm.exhibitor.dto.exhibitor.SmebPassTicketDetailsDTO;

import java.util.List;

public interface SmebPassTicketTotalServiceExport {

    void initializePassTicketTotal();

    /**
     * 根据 uniqueId 刷新 pass_ticket_total 数据
     * @param uniqueId uniqueId
     */
    void refreshPassTicketTotal(String uniqueId);

    void refreshSingle(Integer id);

    List<SmebPassTicketTotal> listCountByBoothId();

    List<SmebPassTicketTotal> listCountBySignTime();

    PageInfo<SmebPassTicketTotal> getDetailByBoothId(SmebPassTicketTotal smebPassTicketTotal, Integer type);

    /**
     * 统计当前届数每个展馆的签到和未签到数量
     * @return {@link SmebPassTicketCountInfoDTO}
     */
    List<SmebPassTicketCountInfoDTO> countByBoothId();

    /**
     * 根据展馆号和签到状态来分页查询展商信息
     * @param params {@link SmebPassTicketDetailsDTO}
     * @return {@link SmebPassTicketDetailsDTO}
     */
    PageInfo<SmebPassTicketDetailsDTO> findSignInInfo(SmebPassTicketDetailsDTO params);

    List<SmebPassTicketDetailsDTO> findSignInInfoList(SmebPassTicketDetailsDTO params);

    boolean updateReceivePerson(Integer id, String name, String mobile, String userName);

    PageInfo<SmebPassTicketTotal> passTicketTotalPage(SmebPassTicketTotal smebPassTicketTotal);

    boolean costNumber(Integer id,Integer number,String userName);

    void updateStatus(String exhibitorUniqueId,Integer boothCost,Integer exhibitorCost );

    void update(SmebPassTicketTotal params);
}
