package com.simm.exhibitor.vo.reservation;

import com.simm.common.vo.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *  ServiceKindVO
 * @author chenyong
 * @since 2018/12/29 10:23
 **/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class ServiceKindVO extends BaseVO {

    @ApiModelProperty("主键id")
    private Integer id;

    @ApiModelProperty("种类名称")
    private String kindName;

    @ApiModelProperty("")
    private String kindNameEn;

    @ApiModelProperty("结算方式")
    private String paymentMethod;

    @ApiModelProperty("提示")
    private String prompt;

    @ApiModelProperty("英文提示")
    private String promptEn;

    @ApiModelProperty("启用(1:是,0:否)")
    private Integer enable;

    @ApiModelProperty("排序")
    private Integer sort;

    @ApiModelProperty("展位类型（1:标摊,2:光地）")
    private String boothType;

}
