package com.simm.exhibitor.vo.shipment;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author liutao
 * @since 2024/1/29
 */
@Data
@ColumnWidth(30)
public class ShipmentDeclareExhibitExcelVO implements Serializable {

    @ExcelProperty("进馆日期")
    private String workDate;

    @ExcelProperty("展位号")
    private String boothNo;

    @ExcelProperty("展商名称")
    private String exhibitorName;

    @ExcelProperty("长(米)")
    private BigDecimal len;

    @ExcelProperty("宽(米)")
    private BigDecimal width;

    @ExcelProperty("高(米)")
    private BigDecimal height;

    @ExcelProperty("体积(立方米)")
    private BigDecimal volume;

    @ExcelProperty("进出馆")
    private String transport;

    @ExcelProperty("重量(吨)")
    private BigDecimal weight;

    @ExcelProperty("空箱体积(立方米)")
    private BigDecimal packageVolume;

    @ExcelProperty("包装类型")
    private String packageType;

    @ExcelProperty("备注")
    private String remark;

}
