package com.simm.exhibitor.vo.shipment;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author liutao
 * @since 2024/8/16
 */
@Data
public class ShipmentDeclarePageVO implements Serializable {

    private Integer id;


    /**
     * 展商uniqueId
     */
    private String uniqueId;

    /**
     * 公司名
     */
    private String businessName;

    /**
     * 展位号
     */
    private String boothNo;

    /**
     * 展位面积
     */
    private Double boothArea;

    /**
     * 展位类型
     */
    private Integer boothType;

    /**
     * 联系人
     */
    private String contactName;

    /**
     * 联系电话
     */
    private String contactMobile;
    /**
     * 申报状态（1：未申报,2：一申报，3：已回传申报单）
     */
    private Integer declarationStatus;

    /**
     * 预付款总金额
     */
    private Integer waitConfirmTotalMoney;

    /**
     * 预付款状态
     */
    private Integer waitConfirmMoneyStatus;

    /**
     * 申报单回签url
     */
    private String declarationSignUrl;
    /**
     * 申报单url
     */
    private String declarationUrl;

    /**
     * 申报金额
     */
    private Integer declareAmount;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date lastUpdateTime;
}
