package org.example.common.config;

import cn.hutool.core.util.StrUtil;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import java.util.Collections;

/**
 * @author liutao
 * @since 2023/12/10
 */
@Configuration
public class RedissonConfig {

    @Resource
    private RedisProperties redisProperties;

    @Bean(name = "redissonClient")
    @ConditionalOnProperty(name = "redis.arrange.type", havingValue = "single")
    public RedissonClient singleRedissonClient() {
        Config config = new Config();
        SingleServerConfig singleServerConfig = config.useSingleServer();
        singleServerConfig.setAddress("redis://"+redisProperties.getHost()+":"+redisProperties.getPort()).setDatabase(redisProperties.getDatabase());
        if (!StrUtil.isEmpty(redisProperties.getPassword())){
            singleServerConfig.setPassword(redisProperties.getPassword());
        }
        return Redisson.create(config);
    }

    @Bean(name = "redissonClient")
    @ConditionalOnProperty(name = "redis.arrange.type", havingValue = "cluster")
    public RedissonClient clusterRedissonClient(){
        Config config = new Config();
        ClusterServersConfig clusterServersConfig = config.useClusterServers();
        clusterServersConfig.setNodeAddresses(Collections.singletonList("redis://"+redisProperties.getHost()+":"+redisProperties.getPort()));
        if (!StrUtil.isEmpty(redisProperties.getPassword())){
            clusterServersConfig.setPassword(redisProperties.getPassword());
        }
        return Redisson.create(config);
    }

}
