package org.example.common.thirty.entity;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author liutao
 * @since 2024/11/25
 */
@Data
public class CompanyBaseInfoData implements Serializable {




    /**
     * 公司曾用名
     */
    private String historyNames;

    /**
     * 注销日期
     */
    private Long cancelDate;

    /**
     * 存续状态
     */
    private String regStatus;

    /**
     * 注册资本
     */
    private String regCapital;
    /**
     * 公司所在市
     */
    private String city;

    /**
     * 人员规模
     */
    private String staffNumRange;
    /**
     * 股票代码
     */
    private String bondNum;

    /**
     * 公司曾用名
     */
    private List<String> historyNameList;

    /**
     * 行业
     */
    private String industry;

    /**
     * 股票名称
     */
    private String bondName;

    /**
     * 吊销日期
     */
    private Long revokeDate;

    /**
     * 吊销原因
     */
    private String revokeReason;

    /**
     * 法人类型 1 人 2 公司
     */
    private Integer type;
    /**
     * 更新时间
     */
    private Long updateTimes;

    /**
     * 法人
     */
    private String legalPersonName;

    /**
     * 注册号
     */
    private String regNumber;
    /**
     * 统一社会信用代码
     */
    private String creditCode;

    /**
     * 英文名
     */
    private String property3;

    /**
     * 股票曾用名
     */
    private String usedBondName;

    /**
     * 核准时间
     */
    private Long approvedTime;

    /**
     * 经营开始时间
     */
    private Long fromTime;

    /**
     * 参保人数
     */
    private Integer socialStaffNum;

    /**
     * 实收注册资本币种
     */
    private String actualCapitalCurrency;

    /**
     * 公司ID
     */
    private Long id;
    /**
     * 公司简称
     */
    private String alias;

    /**
     * 公司类型
     */
    private String companyOrgType;

    /**
     * 注销原因
     */
    private String cancelReason;

    /**
     * 组织机构代码
     */
    private String orgNumber;

    /**
     * 经营结束时间
     */
    private Long toTime;

    /**
     * 实收注册资本
     */
    private String actualCapital;

    /**
     * 成立日期
     */
    private Long estiblishTime;

    /**
     * 登记机关
     */
    private String regInstitute;
    /**
     * 营业范围
     */
    private String businessScope;

    /**
     * 纳税人识别号
     */
    private String taxNumber;

    /**
     * 注册地
     */
    private String regLocation;

    /**
     * 注册资本币种
     */
    private String regCapitalCurrency;

    /**
     * 公司标签
     */
    private String tags;
    /**
     * 公司所在区
     */
    private String district;

    /**
     * 股票类型
     */
    private String bondType;
    /**
     * 公司全称
     */
    private String name;

    /**
     * 公司评分
     */
    private Integer percentileScore;

    /**
     * 国民经济行业分类
     */
    private Industry industryAll;

    /**
     * 是否为小微企业 0 不是 1 时
     */
    private Integer isMicroEnt;

    /**
     * 公司所在省
     */
    private String base;


    @Data
   public static class Industry  implements Serializable{
        /**
         * 国民经济行业分类中类
         */
        private String categoryMiddle;
        /**
         * 国民经济行业分类大类
         */
        private String categoryBig;

        /**
         * 国民经济行业分类小类
         */
        private String categorySmall;

        /**
         * 国民经济行业分类门类
         */
        private String category;
    }
}
