package org.example.common.thirty.impl;

import com.alibaba.fastjson2.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.example.common.cache.RedisCacheService;
import org.example.common.constant.Constants;
import org.example.common.enums.ShortLinkChannelEnum;
import org.example.common.exception.ApiCallException;
import org.example.common.exception.ShortUrlException;
import org.example.common.thirty.ShortLinkService;
import org.example.common.thirty.entity.ShortLinkGenerateRequest;
import org.example.common.util.HttpUtil;
import org.example.common.util.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;
import java.util.concurrent.TimeUnit;


/**
 * @author liutao
 * @since 2024/3/8
 */
@Service
@Slf4j
public class WxMaShortLinkServiceImpl implements ShortLinkService {


    private static final String ACCESS_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
    private static final String GENERATE_URL_LINK = "https://api.weixin.qq.com/wxa/generate_urllink?access_token=%s";


    @Resource
    private RedisCacheService redisCacheService;

    @Override
    public String create(ShortLinkGenerateRequest request) {
        if (StringUtils.isEmpty(request.getLongUrl())) {
            throw new ShortUrlException("长链不能为空");
        }
        String appInfo = request.getAppId() + "," + request.getSecret();
        String accessToken = redisCacheService.queryWithMutex(Constants.WX_MA_SHORT_LINK_TOKEN_KEY,
                appInfo, String.class, this::getAccessToken,7000L, TimeUnit.SECONDS);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("path",request.getLongUrl());
        jsonObject.put("query",getQueryString(request.getQuery()));
        jsonObject.put("expire_type",1);
        jsonObject.put("expire_interval",30);
        JSONObject response = HttpUtil.post(String.format(GENERATE_URL_LINK, accessToken), jsonObject.toJSONString(), JSONObject.class);
        if (response.containsKey("url_link")) {
            return response.getString("url_link");
        }
        throw new ShortUrlException(String.format("微信小程序短链生成失败：%s,%s",response.getString("errcode"),response.getString("errmsg")));
    }

    @Override
    public String create(String longUrl) {
        return create(longUrl, null);
    }

    @Override
    public String create(String longUrl, Map<String, Object> query) {
        return null;
    }


    @Override
    public ShortLinkChannelEnum type() {
        return ShortLinkChannelEnum.wxMiniApp;
    }

    private String getAccessToken(String appInfo) {
        String[] arr = appInfo.split(",");
        JSONObject jsonObject = HttpUtil.get(String.format(ACCESS_TOKEN_URL, arr[0], arr[1]), JSONObject.class);
        if (jsonObject.containsKey("access_token")) {
            return jsonObject.getString("access_token");
        }
        throw new ApiCallException("微信小程序短链api调用失败");
    }
}
