package org.example.common.util;

import com.alibaba.excel.annotation.ExcelProperty;
import org.springframework.util.CollectionUtils;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.groups.Default;
import java.lang.reflect.Field;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author liutao
 * @since 2021/2/19
 */
public class ValidateUtil {


    private static final Validator VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();


    public static List<String> validateBean(Object obj) {
        Set<ConstraintViolation<Object>> constraintViolations = VALIDATOR.validate(obj, Default.class);
        if (CollectionUtils.isEmpty(constraintViolations)) {
            return Collections.emptyList();
        }
        return constraintViolations.stream().map(ConstraintViolation::getMessage).collect(Collectors.toList());
    }

    public static boolean isAllFieldNull(Object obj) {
        try {
            List<Field> fields = Arrays.stream(obj.getClass().getDeclaredFields())
                    .filter(f -> f.isAnnotationPresent(ExcelProperty.class))
                    .collect(Collectors.toList());
            List<Boolean> lineNullList = new ArrayList<>(fields.size());
            for (Field field : fields) {
                field.setAccessible(true);
                Object value = field.get(obj);
                if (Objects.isNull(value)) {
                    lineNullList.add(Boolean.TRUE);
                } else {
                    lineNullList.add(Boolean.FALSE);
                }
            }
            return lineNullList.stream().allMatch(Boolean.TRUE::equals);
        } catch (IllegalAccessException e) {
            return true;
        }
    }

}