package org.example.common.config;

import com.volcengine.ark.runtime.service.ArkService;
import lombok.extern.slf4j.Slf4j;
import org.example.common.ai.ChatService;
import org.example.common.ai.ToolCallBackProvider;
import org.example.common.ai.impl.ChatServiceImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.time.Duration;
import java.util.List;

/**
 * 火山引擎ai接口
 * @author liutao
 * @since 2024/6/20
 */
@Slf4j
@Configuration
@ConditionalOnProperty(name = "ark.enable", havingValue = "true")
public class ArkConfiguration {


    @Value("${ark.apiKey:4d181319-59ee-42a4-8d83-f94d64de2041}")
    private String apiKey;

    @Value("${ark.timeout:60}")
    private int timeout;

    @Value("${ark.connectTimeout:60}")
    private int connectTimeout;

    @Value("${ark.retryTimes:3}")
    private int retryTimes;


    @Bean
    public ArkService arkService() {
        return ArkService.builder()
                .apiKey(apiKey)
                .timeout(Duration.ofSeconds(timeout))
                .connectTimeout(Duration.ofSeconds(connectTimeout))
                .retryTimes(retryTimes)
                .build();
    }

    @Bean
    public ChatService chatService(ArkService arkService, List<ToolCallBackProvider> toolCallBackProviders) {
        return new ChatServiceImpl(arkService,toolCallBackProviders);
    }

}
