package org.example.common.exception;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.example.common.enums.HttpCodeEnum;

/**
 * @author liutao
 * @since 2024/4/7
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ServiceException extends RuntimeException{

    private HttpCodeEnum httpCodeEnum;

    private Object data;

    public ServiceException(String msg) {
        super(msg);
    }

    public ServiceException(String msg, Object data) {
        super(msg);
        this.data = data;
    }

    public ServiceException(HttpCodeEnum httpCodeEnum) {
        super(httpCodeEnum.getDesc());
        this.httpCodeEnum = httpCodeEnum;
    }
}
