package org.example.common.oapi;

import cn.hutool.core.util.ArrayUtil;
import com.lark.oapi.Client;
import com.lark.oapi.service.bitable.v1.model.*;
import lombok.RequiredArgsConstructor;

import java.util.Objects;

/**
 * @author liutao
 * @since 2024/2/5
 */
@RequiredArgsConstructor
public class BiTableServiceImpl implements BiTableService {

    private final Client client;
    @Override
    public BatchCreateAppTableRecordResp batchCreate(AppTableRecord[] fields, String tableId, String appToken ) throws Exception {
        if (ArrayUtil.isEmpty(fields)) {
            return new BatchCreateAppTableRecordResp();
        }
        // 创建请求对象
        BatchCreateAppTableRecordReq req = BatchCreateAppTableRecordReq.newBuilder()
                .batchCreateAppTableRecordReqBody(BatchCreateAppTableRecordReqBody.newBuilder()
                        .records(fields)
                        .build())
                .build();
        req.setAppToken(appToken);
        req.setTableId(tableId);
        // 发起请求
        return client.bitable().appTableRecord().batchCreate(req);
    }

    @Override
    public BatchUpdateAppTableRecordResp batchUpdate(AppTableRecord[] items, String tableId, String appToken) throws Exception {
        if (ArrayUtil.isEmpty(items)) {
            return new BatchUpdateAppTableRecordResp();
        }
        return client.bitable().appTableRecord().batchUpdate(BatchUpdateAppTableRecordReq.newBuilder()
                .appToken(appToken)
                .tableId(tableId)
                .batchUpdateAppTableRecordReqBody(BatchUpdateAppTableRecordReqBody.newBuilder()
                        .records(items)
                        .build())
                .build());
    }
    @Override
    public AppTableRecord[] search(String tableId, String viewId, String appToken, FilterInfo filterInfo, String[] fields) throws Exception {
        SearchAppTableRecordReq req = SearchAppTableRecordReq.newBuilder()
                .tableId(tableId)
                .appToken(appToken)
                .searchAppTableRecordReqBody(SearchAppTableRecordReqBody
                        .newBuilder()
                        .viewId(viewId)
                        .filter(filterInfo)
                        .automaticFields(true)
                        .fieldNames(fields)
                        .build()).build();
        SearchAppTableRecordResp resp = client.bitable().appTableRecord().search(req);
        SearchAppTableRecordRespBody recordRespBody = resp.getData();
        if (Objects.nonNull(recordRespBody)) {
            return recordRespBody.getItems();
        }
        return null;
    }

    @Override
    public DeleteAppTableRecordResp delete(String tableId, String recordId, String appToken) throws Exception {
        return client.bitable().appTableRecord().delete(DeleteAppTableRecordReq.newBuilder()
                .appToken(appToken)
                .tableId(tableId)
                .recordId(recordId)
                .build());
    }

    @Override
    public BatchDeleteAppTableRecordResp batchDelete(String tableId, String[] recordIds, String appToken) throws Exception {
        return client.bitable().appTableRecord().batchDelete(BatchDeleteAppTableRecordReq.newBuilder()
                .appToken(appToken)
                .tableId(tableId)
                .batchDeleteAppTableRecordReqBody(BatchDeleteAppTableRecordReqBody.newBuilder()
                        .records(recordIds).build())
                .build());
    }
}
