package org.example.common.trans;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @author liutao
 * @since 2025/11/25
 */
@Data
public class TranslationResponse {

    /**
     * 错误码
     */
    private Integer code;


    /**
     * 翻译结果
     */
    private TransData data;


    @Data
    public static class TransData {

        /**
         * 翻译结果
         */
        private Result result;
    }

    @Data
    public static class Result {
        /**
         * 源语种
         */
        private String from;
        /**
         * 目标语种
         */
        private String to;
        /**
         * 翻译结果
         */
        @JsonProperty("trans_result")
        private TransResult transResult;
    }


    @Data
    public static class TransResult {
        /**
         * 源文本
         */
        private String src;
        /**
         * 目标文本
         */
        private String dst;
    }
}
