/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.config.springboot.starter.config;

import cn.hippo4j.config.springboot.starter.refresher.ApolloRefresherHandler;
import cn.hippo4j.config.springboot.starter.refresher.BootstrapConfigPropertiesBinderAdapt;
import cn.hippo4j.config.springboot.starter.refresher.DefaultBootstrapConfigPropertiesBinderAdapt;
import cn.hippo4j.config.springboot.starter.refresher.EtcdRefresherHandler;
import cn.hippo4j.config.springboot.starter.refresher.NacosCloudRefresherHandler;
import cn.hippo4j.config.springboot.starter.refresher.NacosRefresherHandler;
import cn.hippo4j.config.springboot.starter.refresher.PolarisRefresherHandler;
import cn.hippo4j.config.springboot.starter.refresher.ZookeeperRefresherHandler;
import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.ctrip.framework.apollo.ConfigService;
import com.tencent.polaris.configuration.api.core.ConfigFileService;
import io.etcd.jetcd.Client;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class ConfigHandlerConfiguration {
    private static final String NACOS_CONFIG_MANAGER_KEY = "com.alibaba.cloud.nacos.NacosConfigManager";
    private static final String NACOS_DATA_ID_KEY = "nacos.data-id";
    private static final String APOLLO_NAMESPACE_KEY = "apollo.namespace";
    private static final String ZOOKEEPER_CONNECT_STR_KEY = "zookeeper.zk-connect-str";
    private static final String ETCD = "etcd.endpoints";
    private static final String POLARIS = "config.serverConnector";

    @Bean
    @ConditionalOnMissingBean
    public BootstrapConfigPropertiesBinderAdapt bootstrapConfigPropertiesBinderAdapt() {
        return new DefaultBootstrapConfigPropertiesBinderAdapt();
    }

    @ConditionalOnClass(value={ConfigFileService.class})
    @ConditionalOnProperty(prefix="spring.dynamic.thread-pool", name={"config.serverConnector"})
    static class Polaris {
        Polaris() {
        }

        @Bean
        public PolarisRefresherHandler polarisRefresher(ConfigFileService configFileService) {
            return new PolarisRefresherHandler(configFileService);
        }
    }

    @ConditionalOnClass(value={Client.class})
    @ConditionalOnProperty(prefix="spring.dynamic.thread-pool", name={"etcd.endpoints"})
    static class EmbeddedEtcd {
        EmbeddedEtcd() {
        }

        @Bean
        public EtcdRefresherHandler etcdRefresher() {
            return new EtcdRefresherHandler();
        }
    }

    @ConditionalOnClass(value={CuratorFramework.class})
    @ConditionalOnProperty(prefix="spring.dynamic.thread-pool", name={"zookeeper.zk-connect-str"})
    static class EmbeddedZookeeper {
        EmbeddedZookeeper() {
        }

        @Bean
        public ZookeeperRefresherHandler zookeeperRefresher() {
            return new ZookeeperRefresherHandler();
        }
    }

    @ConditionalOnClass(value={ConfigService.class})
    @ConditionalOnProperty(prefix="spring.dynamic.thread-pool", name={"apollo.namespace"})
    static class EmbeddedApollo {
        EmbeddedApollo() {
        }

        @Bean
        public ApolloRefresherHandler apolloRefresher() {
            return new ApolloRefresherHandler();
        }
    }

    @ConditionalOnClass(value={NacosConfigManager.class})
    @ConditionalOnProperty(prefix="spring.dynamic.thread-pool", name={"nacos.data-id"})
    static class EmbeddedNacosCloud {
        EmbeddedNacosCloud() {
        }

        @Bean
        public NacosCloudRefresherHandler nacosCloudRefresherHandler() {
            return new NacosCloudRefresherHandler();
        }
    }

    @ConditionalOnClass(value={com.alibaba.nacos.api.config.ConfigService.class})
    @ConditionalOnMissingClass(value={"com.alibaba.cloud.nacos.NacosConfigManager"})
    @ConditionalOnProperty(prefix="spring.dynamic.thread-pool", name={"nacos.data-id"})
    static class EmbeddedNacos {
        @Bean
        public NacosRefresherHandler nacosRefresherHandler(NacosConfigProperties nacosConfigProperties) {
            return new NacosRefresherHandler(nacosConfigProperties);
        }

        @Generated
        public EmbeddedNacos() {
        }
    }
}

