/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.config.springboot.starter.refresher;

import cn.hippo4j.common.toolkit.JSONUtil;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.config.springboot.starter.refresher.AbstractConfigThreadPoolDynamicRefresh;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.ClientBuilder;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.watch.WatchEvent;
import io.etcd.jetcd.watch.WatchResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdRefresherHandler
extends AbstractConfigThreadPoolDynamicRefresh {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EtcdRefresherHandler.class);
    private Client client;
    private static final String ENDPOINTS = "endpoints";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String CHARSET = "charset";
    private static final String AUTHORITY = "authority";
    private static final String KEY = "key";

    public String getProperties() throws Exception {
        Map<String, String> etcd = this.bootstrapConfigProperties.getEtcd();
        Charset charset = StringUtil.isBlank((CharSequence)etcd.get(CHARSET)) ? StandardCharsets.UTF_8 : Charset.forName(etcd.get(CHARSET));
        this.initClient(etcd, charset);
        String key = etcd.get(KEY);
        GetResponse getResponse = (GetResponse)this.client.getKVClient().get(ByteSequence.from((String)key, (Charset)charset)).get();
        KeyValue keyValue = (KeyValue)getResponse.getKvs().get(0);
        return Objects.isNull(keyValue) ? null : keyValue.getValue().toString(charset);
    }

    public void afterPropertiesSet() throws Exception {
        Map<String, String> etcd = this.bootstrapConfigProperties.getEtcd();
        final String key = etcd.get(KEY);
        final Charset charset = StringUtil.isBlank((CharSequence)etcd.get(CHARSET)) ? StandardCharsets.UTF_8 : Charset.forName(etcd.get(CHARSET));
        this.initClient(etcd, charset);
        GetResponse getResponse = (GetResponse)this.client.getKVClient().get(ByteSequence.from((String)key, (Charset)charset)).get();
        KeyValue keyValue = (KeyValue)getResponse.getKvs().get(0);
        if (Objects.isNull(keyValue)) {
            return;
        }
        this.client.getWatchClient().watch(ByteSequence.from((String)key, (Charset)charset), new Watch.Listener(){

            public void onNext(WatchResponse response) {
                WatchEvent watchEvent = (WatchEvent)response.getEvents().get(0);
                WatchEvent.EventType eventType = watchEvent.getEventType();
                if (Objects.equals(eventType, WatchEvent.EventType.PUT)) {
                    KeyValue keyValue1 = watchEvent.getKeyValue();
                    String value = keyValue1.getValue().toString(charset);
                    Map map = (Map)JSONUtil.parseObject((String)value, Map.class);
                    EtcdRefresherHandler.this.dynamicRefresh(keyValue1.getKey().toString(charset), map);
                }
            }

            public void onError(Throwable throwable) {
                log.error("Dynamic thread pool etcd config watcher exception ", throwable);
            }

            public void onCompleted() {
                log.info("Dynamic thread pool etcd config key refreshed, config key {}", (Object)key);
            }
        });
    }

    private void initClient(Map<String, String> etcd, Charset charset) {
        if (Objects.isNull(this.client)) {
            String user = etcd.get(USER);
            String password = etcd.get(PASSWORD);
            String authority = etcd.get(AUTHORITY);
            String endpoints = etcd.get(ENDPOINTS);
            ClientBuilder clientBuilder = Client.builder().endpoints(endpoints.split(","));
            this.client = StringUtil.isAllNotEmpty((CharSequence[])new CharSequence[]{user, password}) ? clientBuilder.user(ByteSequence.from((String)user, (Charset)charset)).password(ByteSequence.from((String)password, (Charset)charset)).authority(authority).build() : clientBuilder.build();
        }
    }
}

