/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.config.springboot.starter.refresher;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.config.springboot.starter.refresher.AbstractConfigThreadPoolDynamicRefresh;
import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.nacos.api.config.listener.Listener;
import java.util.Map;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosCloudRefresherHandler
extends AbstractConfigThreadPoolDynamicRefresh {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NacosCloudRefresherHandler.class);
    static final String DATA_ID = "data-id";
    static final String GROUP = "group";
    private final NacosConfigManager nacosConfigManager = (NacosConfigManager)ApplicationContextHolder.getBean(NacosConfigManager.class);

    public String getProperties() throws Exception {
        Map<String, String> nacosConfig = this.bootstrapConfigProperties.getNacos();
        String dataId = nacosConfig.get(DATA_ID);
        String group = nacosConfig.get(GROUP);
        return this.nacosConfigManager.getConfigService().getConfig(dataId, group, 5000L);
    }

    public void afterPropertiesSet() throws Exception {
        Map<String, String> nacosConfig = this.bootstrapConfigProperties.getNacos();
        this.nacosConfigManager.getConfigService().addListener(nacosConfig.get(DATA_ID), nacosConfig.get(GROUP), new Listener(){

            public Executor getExecutor() {
                return NacosCloudRefresherHandler.this.dynamicRefreshExecutorService;
            }

            public void receiveConfigInfo(String configInfo) {
                NacosCloudRefresherHandler.this.dynamicRefresh(configInfo);
            }
        });
        log.info("Dynamic thread pool refresher, add nacos cloud listener success. data-id: {}, group: {}", (Object)nacosConfig.get(DATA_ID), (Object)nacosConfig.get(GROUP));
    }
}

