/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.config.springboot.starter.support;

import cn.hippo4j.common.executor.support.BlockingQueueTypeEnum;
import cn.hippo4j.common.executor.support.RejectedPolicyTypeEnum;
import cn.hippo4j.common.model.register.DynamicThreadPoolRegisterParameter;
import cn.hippo4j.common.model.register.DynamicThreadPoolRegisterWrapper;
import cn.hippo4j.common.model.register.notify.DynamicThreadPoolRegisterCoreNotifyParameter;
import cn.hippo4j.common.toolkit.BooleanUtil;
import cn.hippo4j.config.springboot.starter.config.ExecutorProperties;
import cn.hippo4j.config.springboot.starter.support.GlobalCoreThreadPoolManage;
import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.executor.support.service.AbstractDynamicThreadPoolService;
import cn.hippo4j.message.service.GlobalNotifyAlarmManage;
import cn.hippo4j.message.service.ThreadPoolNotifyAlarm;
import java.util.concurrent.ThreadPoolExecutor;

public class DynamicThreadPoolConfigService
extends AbstractDynamicThreadPoolService {
    public ThreadPoolExecutor registerDynamicThreadPool(DynamicThreadPoolRegisterWrapper registerWrapper) {
        DynamicThreadPoolRegisterParameter registerParameter = registerWrapper.getParameter();
        String threadPoolId = registerParameter.getThreadPoolId();
        ThreadPoolExecutor dynamicThreadPoolExecutor = this.buildDynamicThreadPoolExecutor(registerParameter);
        DynamicThreadPoolWrapper dynamicThreadPoolWrapper = DynamicThreadPoolWrapper.builder().threadPoolId(threadPoolId).executor(dynamicThreadPoolExecutor).build();
        GlobalThreadPoolManage.registerPool((String)threadPoolId, (DynamicThreadPoolWrapper)dynamicThreadPoolWrapper);
        ExecutorProperties executorProperties = this.buildExecutorProperties(registerWrapper);
        GlobalCoreThreadPoolManage.register(threadPoolId, executorProperties);
        DynamicThreadPoolRegisterCoreNotifyParameter notifyParameter = registerWrapper.getConfigNotify();
        ThreadPoolNotifyAlarm notifyAlarm = new ThreadPoolNotifyAlarm(Boolean.valueOf(true), registerParameter.getActiveAlarm(), registerParameter.getCapacityAlarm());
        notifyAlarm.setReceives(notifyParameter.getReceives());
        notifyAlarm.setInterval(notifyParameter.getInterval());
        GlobalNotifyAlarmManage.put((String)threadPoolId, (ThreadPoolNotifyAlarm)notifyAlarm);
        return dynamicThreadPoolExecutor;
    }

    private ExecutorProperties buildExecutorProperties(DynamicThreadPoolRegisterWrapper registerWrapper) {
        DynamicThreadPoolRegisterParameter registerParameter = registerWrapper.getParameter();
        ExecutorProperties executorProperties = ExecutorProperties.builder().corePoolSize(registerParameter.getCorePoolSize()).maximumPoolSize(registerParameter.getMaximumPoolSize()).allowCoreThreadTimeOut(BooleanUtil.toBoolean((String)String.valueOf(registerParameter.getAllowCoreThreadTimeOut()))).keepAliveTime(registerParameter.getKeepAliveTime()).blockingQueue(BlockingQueueTypeEnum.getBlockingQueueNameByType((int)registerParameter.getBlockingQueueType().getType())).queueCapacity(registerParameter.getCapacity()).threadNamePrefix(registerParameter.getThreadNamePrefix()).rejectedHandler(RejectedPolicyTypeEnum.getRejectedNameByType((int)registerParameter.getRejectedPolicyType().getType())).executeTimeOut(registerParameter.getExecuteTimeOut()).threadPoolId(registerParameter.getThreadPoolId()).build();
        return executorProperties;
    }
}

