/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs;

import cn.zhxu.bs.SearchException;
import cn.zhxu.bs.SearchSql;
import java.io.Closeable;
import java.sql.SQLException;

public class SqlResult<T>
implements Closeable {
    private final SearchSql<T> searchSql;
    private final ResultSet listResult;
    private final Result clusterResult;
    private int pageSize;

    public SqlResult(SearchSql<T> searchSql) {
        this(searchSql, null, null);
    }

    public SqlResult(SearchSql<T> searchSql, ResultSet listResult, Result clusterResult) {
        this.searchSql = searchSql;
        this.listResult = listResult;
        this.clusterResult = clusterResult;
    }

    @Override
    public void close() {
        try {
            if (this.listResult != null) {
                this.listResult.close();
            }
            if (this.clusterResult != null) {
                this.clusterResult.close();
            }
        }
        catch (SQLException e) {
            throw new SearchException("Can not close result or resultSet!", e);
        }
    }

    public SearchSql<T> getSearchSql() {
        return this.searchSql;
    }

    public ResultSet getListResult() {
        return this.listResult;
    }

    public Result getClusterResult() {
        return this.clusterResult;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public static interface ResultSet
    extends Result {
        public static final ResultSet EMPTY = new ResultSet(){

            @Override
            public boolean next() {
                return false;
            }

            @Override
            public Object get(String columnLabel) {
                return null;
            }
        };

        public boolean next() throws SQLException;
    }

    public static interface Result
    extends AutoCloseable {
        public Object get(String var1) throws SQLException;

        @Override
        default public void close() throws SQLException {
        }
    }
}

