/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.filter;

import cn.zhxu.bs.BeanMeta;
import cn.zhxu.bs.IllegalParamException;
import cn.zhxu.bs.ParamFilter;
import cn.zhxu.bs.util.MapUtils;
import cn.zhxu.bs.util.RpcNames;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ArrayValueParamFilter
implements ParamFilter {
    private final String separator;

    public ArrayValueParamFilter() {
        this(RpcNames.DEFAULT.separator());
    }

    public ArrayValueParamFilter(String separator) {
        this.separator = Objects.requireNonNull(separator);
    }

    @Override
    public <T> Map<String, Object> doFilter(BeanMeta<T> beanMeta, Map<String, Object> paraMap) throws IllegalParamException {
        List<String> keys = MapUtils.obtainList(paraMap, MapUtils.ARRAY_KEYS, false);
        if (keys == null) {
            return paraMap;
        }
        for (String key : keys) {
            Object value;
            if (key == null || key.contains(this.separator) || !((value = paraMap.get(key)) instanceof String[])) continue;
            String[] vs = (String[])value;
            for (int i = 0; i < vs.length; ++i) {
                paraMap.put(key + this.separator + i, vs[i]);
            }
        }
        return paraMap;
    }

    public String getSeparator() {
        return this.separator;
    }
}

