/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;

public class AnnoUtils {
    public static boolean isAnnotated(AnnotatedElement element, Class<? extends Annotation> annoClass) {
        return AnnoUtils.getAnnotation(element, annoClass) != null;
    }

    public static <T extends Annotation> T getAnnotation(AnnotatedElement element, Class<T> annoClass) {
        if (element == null) {
            return null;
        }
        T annotation = element.getAnnotation(annoClass);
        if (annotation != null) {
            return annotation;
        }
        return AnnoUtils.getAnnotation(element, annoClass, new ArrayList<Annotation>());
    }

    private static <T extends Annotation> T getAnnotation(AnnotatedElement element, Class<T> annoClass, List<Annotation> checked) {
        for (Annotation anno : element.getAnnotations()) {
            if (checked.contains(anno)) continue;
            if (annoClass.isInstance(anno)) {
                return (T)anno;
            }
            checked.add(anno);
            T ann = AnnoUtils.getAnnotation(anno.annotationType(), annoClass, checked);
            if (ann == null) continue;
            return ann;
        }
        return null;
    }
}

