/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.util;

import cn.zhxu.bs.util.StringUtils;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class FieldFns {
    private static final Map<FieldFn<?, ?>, String> cache = new ConcurrentHashMap();

    public static <T> String name(FieldFn<T, ?> fieldFn) {
        String name = cache.get(fieldFn);
        if (name != null) {
            return name;
        }
        try {
            String methodName;
            boolean isInaccessible;
            Method wrMethod = fieldFn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            boolean bl = isInaccessible = !wrMethod.isAccessible();
            if (isInaccessible) {
                wrMethod.setAccessible(true);
            }
            SerializedLambda sLambda = (SerializedLambda)wrMethod.invoke(fieldFn, new Object[0]);
            if (isInaccessible) {
                wrMethod.setAccessible(false);
            }
            if ((methodName = sLambda.getImplMethodName()).startsWith("get") && methodName.length() > 3) {
                name = StringUtils.firstCharToLoweCase(methodName.substring(3));
            }
            if (methodName.startsWith("is") && methodName.length() > 2) {
                name = StringUtils.firstCharToLoweCase(methodName.substring(2));
            }
            if (name != null) {
                cache.put(fieldFn, name);
                return name;
            }
            throw new IllegalStateException("Can not resolve the name of method: " + methodName);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Can not resolve the name of " + fieldFn, e);
        }
    }

    @FunctionalInterface
    public static interface FieldFn<T, R>
    extends Function<T, R>,
    Serializable {
    }
}

