/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.util;

import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class MapUtils {
    public static final String ARRAY_KEYS = "ARRAY_KEYS." + UUID.randomUUID();

    public static Map<String, Object> flat(Map<String, String[]> map) {
        return MapUtils.flat(map, true);
    }

    public static Map<String, Object> flat(Map<String, String[]> map, boolean urlDecode) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            String[] values = MapUtils.urlDecode(entry.getValue(), urlDecode);
            if (values == null || values.length == 0) {
                newMap.put(key, null);
                continue;
            }
            if (values.length == 1) {
                newMap.put(key, values[0]);
                continue;
            }
            MapUtils.obtainList(newMap, ARRAY_KEYS).add(key);
            newMap.put(key, values);
        }
        return newMap;
    }

    static String[] urlDecode(String[] values, boolean urlDecode) {
        if (values == null || values.length == 0 || !urlDecode) {
            return values;
        }
        String[] decodedValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                decodedValues[i] = URLDecoder.decode(values[i], Charset.defaultCharset().name());
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        return decodedValues;
    }

    public static MapBuilder builder() {
        return MapUtils.builder(new HashMap<String, Object>());
    }

    public static MapBuilder flatBuilder(Map<String, String[]> map) {
        return new MapBuilder(MapUtils.flat(map));
    }

    public static MapBuilder flatBuilder(Map<String, String[]> map, boolean urlDecode) {
        return new MapBuilder(MapUtils.flat(map, urlDecode));
    }

    public static MapBuilder builder(Map<String, Object> map) {
        return new MapBuilder(map);
    }

    public static Map<String, Object> of(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        return map;
    }

    public static Map<String, Object> of(String key1, Object value1, String key2, Object value2) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static <T> Map<String, Object> of(FieldFns.FieldFn<T, ?> key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FieldFns.name(key), value);
        return map;
    }

    public static <T> Map<String, Object> of(FieldFns.FieldFn<T, ?> key1, Object value1, FieldFns.FieldFn<T, ?> key2, Object value2) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FieldFns.name(key1), value1);
        map.put(FieldFns.name(key2), value2);
        return map;
    }

    public static <T> List<T> obtainList(Map<String, Object> map, String key) {
        return MapUtils.obtainList(map, key, true);
    }

    public static <T> List<T> obtainList(Map<String, Object> map, String key, boolean createIfNull) {
        Object value = map.get(key);
        ArrayList list = null;
        if (value instanceof List) {
            ArrayList l;
            list = l = (ArrayList)value;
        }
        if (list == null && createIfNull) {
            list = new ArrayList();
            map.put(key, list);
        }
        return list;
    }
}

