/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.util;

import cn.zhxu.bs.util.AndBuilder;
import cn.zhxu.bs.util.Builder;
import java.util.HashMap;
import java.util.function.Consumer;

public class OrBuilder
extends Builder<OrBuilder> {
    private final String parentExpr;
    private String groupExpr;

    public OrBuilder(String parentExpr, String lastGroup) {
        super(new HashMap<String, Object>());
        this.parentExpr = parentExpr;
        this.group = lastGroup;
    }

    @Override
    public OrBuilder field(String fieldName, Object ... values) {
        this.group = this.nextGroup(this.group);
        this.groupExpr = this.groupExpr != null ? this.groupExpr + '|' + this.group : this.group;
        return (OrBuilder)super.field(fieldName, values);
    }

    @Override
    protected boolean isGroupExists(String group) {
        return this.groupExpr != null && this.groupExpr.contains(group) || this.parentExpr != null && this.parentExpr.contains(group);
    }

    public OrBuilder and(Consumer<AndBuilder> condition) {
        AndBuilder builder = new AndBuilder(this.parentExpr + this.groupExpr, this.group);
        condition.accept(builder);
        String expr1 = builder.getGroupExpr();
        if (expr1 != null) {
            String expr0 = this.getGroupExpr();
            if (expr0 != null) {
                this.setGroupExpr('(' + expr0 + ')' + '|' + '(' + expr1 + ')');
            } else {
                this.setGroupExpr('(' + expr1 + ')');
            }
        }
        this.map.putAll(builder.map);
        return this;
    }

    @Override
    protected void setGroupExpr(String groupExpr) {
        this.groupExpr = groupExpr;
    }

    @Override
    protected String getGroupExpr() {
        return this.groupExpr;
    }
}

