/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.dubbo.autoconfigure;

import com.alibaba.boot.dubbo.autoconfigure.DubboConfigProperties;
import com.alibaba.boot.dubbo.autoconfigure.DubboScanProperties;
import com.alibaba.boot.dubbo.autoconfigure.MultipleDubboConfigBindingProperties;
import com.alibaba.boot.dubbo.autoconfigure.SingleDubboConfigBindingProperties;
import com.alibaba.dubbo.config.AbstractConfig;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.ReferenceAnnotationBeanPostProcessor;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.ServiceAnnotationBeanPostProcessor;
import com.alibaba.dubbo.config.spring.context.annotation.EnableDubboConfig;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

@Configuration
@ConditionalOnProperty(prefix="dubbo", name={"enabled"}, matchIfMissing=true, havingValue="true")
@ConditionalOnClass(value={AbstractConfig.class})
@EnableConfigurationProperties(value={DubboScanProperties.class, DubboConfigProperties.class})
public class DubboAutoConfiguration {
    @ConditionalOnProperty(name={"dubbo.scan.basePackages"})
    @Autowired
    @Bean
    public ServiceAnnotationBeanPostProcessor serviceAnnotationBeanPostProcessor(Environment environment) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)environment);
        Set packagesToScan = (Set)resolver.getProperty("dubbo.scan.basePackages", Set.class, Collections.emptySet());
        return new ServiceAnnotationBeanPostProcessor(packagesToScan);
    }

    @ConditionalOnMissingBean
    @Bean(name={"referenceAnnotationBeanPostProcessor"})
    public ReferenceAnnotationBeanPostProcessor referenceAnnotationBeanPostProcessor() {
        return new ReferenceAnnotationBeanPostProcessor();
    }

    @ConditionalOnProperty(name={"dubbo.config.multiple"}, havingValue="true")
    @EnableDubboConfig(multiple=true)
    @EnableConfigurationProperties(value={MultipleDubboConfigBindingProperties.class})
    protected static class MultipleDubboConfigConfiguration {
        protected MultipleDubboConfigConfiguration() {
        }
    }

    @ConditionalOnProperty(name={"dubbo.config.multiple"}, havingValue="false", matchIfMissing=true)
    @EnableDubboConfig
    @EnableConfigurationProperties(value={SingleDubboConfigBindingProperties.class})
    protected static class SingleDubboConfigConfiguration {
        protected SingleDubboConfigConfiguration() {
        }
    }
}

