/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.autoconfigure;

import com.alibaba.boot.nacos.config.autoconfigure.NacosBootConfigException;
import com.alibaba.boot.nacos.config.autoconfigure.NacosConfigEnvironmentProcessor;
import com.alibaba.boot.nacos.config.properties.NacosConfigProperties;
import com.alibaba.boot.nacos.config.util.NacosConfigLoader;
import com.alibaba.boot.nacos.config.util.NacosConfigLoaderFactory;
import com.alibaba.boot.nacos.config.util.NacosConfigPropertiesUtils;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.utils.SnapShotSwitch;
import com.alibaba.nacos.spring.factory.CacheableEventPublishingNacosServiceFactory;
import java.util.Properties;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class NacosConfigApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private final Logger logger = LoggerFactory.getLogger(NacosConfigApplicationContextInitializer.class);
    private final NacosConfigEnvironmentProcessor processor;
    private final CacheableEventPublishingNacosServiceFactory singleton = CacheableEventPublishingNacosServiceFactory.getSingleton();
    private final Function<Properties, ConfigService> builder = properties -> {
        try {
            return this.singleton.createConfigService(properties);
        }
        catch (NacosException e) {
            throw new NacosBootConfigException("ConfigService can't be created with properties : " + properties, e);
        }
    };
    private ConfigurableEnvironment environment;
    private NacosConfigProperties nacosConfigProperties;

    public NacosConfigApplicationContextInitializer(NacosConfigEnvironmentProcessor configEnvironmentProcessor) {
        this.processor = configEnvironmentProcessor;
    }

    public void initialize(ConfigurableApplicationContext context) {
        this.singleton.setApplicationContext((ApplicationContext)context);
        this.environment = context.getEnvironment();
        this.nacosConfigProperties = NacosConfigPropertiesUtils.buildNacosConfigProperties(this.environment);
        NacosConfigLoader configLoader = NacosConfigLoaderFactory.getSingleton(this.builder);
        if (!this.processor.snapshotEnable()) {
            SnapShotSwitch.setIsSnapShot((Boolean)false);
        }
        if (!this.enable()) {
            this.logger.info("[Nacos Config Boot] : The preload configuration is not enabled");
        } else if (this.processor.enable()) {
            this.processor.publishDeferService((ApplicationContext)context);
            configLoader.addListenerIfAutoRefreshed(this.processor.getDeferPropertySources());
        } else {
            configLoader.loadConfig(this.environment, this.nacosConfigProperties);
            configLoader.addListenerIfAutoRefreshed();
        }
        ConfigurableListableBeanFactory factory = context.getBeanFactory();
        if (!factory.containsSingleton("globalNacosProperties")) {
            factory.registerSingleton("globalNacosProperties", (Object)configLoader.getGlobalProperties());
        }
    }

    private boolean enable() {
        return this.processor.enable() || this.nacosConfigProperties.getBootstrap().isEnable();
    }
}

