/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.autoconfigure;

import com.alibaba.boot.nacos.config.autoconfigure.NacosBootConfigException;
import com.alibaba.boot.nacos.config.autoconfigure.NacosConfigApplicationContextInitializer;
import com.alibaba.boot.nacos.config.properties.NacosConfigProperties;
import com.alibaba.boot.nacos.config.util.NacosConfigLoader;
import com.alibaba.boot.nacos.config.util.NacosConfigLoaderFactory;
import com.alibaba.boot.nacos.config.util.NacosConfigPropertiesUtils;
import com.alibaba.boot.nacos.config.util.log.LogAutoFreshProcess;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.spring.factory.CacheableEventPublishingNacosServiceFactory;
import com.alibaba.nacos.spring.util.NacosUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class NacosConfigEnvironmentProcessor
implements EnvironmentPostProcessor,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(NacosConfigEnvironmentProcessor.class);
    private final CacheableEventPublishingNacosServiceFactory nacosServiceFactory = CacheableEventPublishingNacosServiceFactory.getSingleton();
    private final Map<String, ConfigService> serviceCache = new HashMap<String, ConfigService>(8);
    private final LinkedList<NacosConfigLoader.DeferNacosPropertySource> deferPropertySources = new LinkedList();
    private NacosConfigProperties nacosConfigProperties;
    private final Function<Properties, ConfigService> builder = properties -> {
        try {
            String key = NacosUtils.identify((Map)properties);
            if (this.serviceCache.containsKey(key)) {
                return this.serviceCache.get(key);
            }
            ConfigService configService = NacosFactory.createConfigService((Properties)properties);
            this.serviceCache.put(key, configService);
            return (ConfigService)this.nacosServiceFactory.deferCreateService((Object)configService, properties);
        }
        catch (NacosException e) {
            throw new NacosBootConfigException("ConfigService can't be created with properties : " + properties, e);
        }
    };

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        application.addInitializers(new ApplicationContextInitializer[]{new NacosConfigApplicationContextInitializer(this)});
        this.nacosConfigProperties = NacosConfigPropertiesUtils.buildNacosConfigProperties(environment);
        if (this.enable()) {
            System.out.println("[Nacos Config Boot] : The preload log configuration is enabled");
            NacosConfigLoader nacosConfigLoader = NacosConfigLoaderFactory.getSingleton(this.builder);
            this.loadConfig(nacosConfigLoader, environment, this.nacosConfigProperties);
            LogAutoFreshProcess.build(environment, this.nacosConfigProperties, nacosConfigLoader, this.builder).process();
        }
    }

    private void loadConfig(NacosConfigLoader configLoader, ConfigurableEnvironment environment, NacosConfigProperties nacosConfigProperties) {
        configLoader.loadConfig(environment, nacosConfigProperties);
        this.deferPropertySources.addAll(configLoader.getNacosPropertySources());
    }

    boolean enable() {
        return this.nacosConfigProperties != null && this.nacosConfigProperties.getBootstrap().isLogEnable();
    }

    boolean snapshotEnable() {
        return this.nacosConfigProperties != null && this.nacosConfigProperties.getBootstrap().isSnapshotEnable();
    }

    LinkedList<NacosConfigLoader.DeferNacosPropertySource> getDeferPropertySources() {
        return this.deferPropertySources;
    }

    public int getOrder() {
        return 0x7FFFFFFA;
    }

    void publishDeferService(ApplicationContext context) {
        try {
            this.nacosServiceFactory.publishDeferService(context);
            this.serviceCache.clear();
        }
        catch (Exception e) {
            this.logger.error("publish defer ConfigService has some error", (Throwable)e);
        }
    }
}

