/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.util;

import com.alibaba.boot.nacos.config.properties.NacosConfigProperties;
import com.alibaba.boot.nacos.config.util.NacosPropertiesBuilder;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.spring.core.env.NacosPropertySource;
import com.alibaba.nacos.spring.core.env.NacosPropertySourcePostProcessor;
import com.alibaba.nacos.spring.util.NacosUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class NacosConfigLoader {
    private final Logger logger = LoggerFactory.getLogger(NacosConfigLoader.class);
    private Properties globalProperties = new Properties();
    private final Function<Properties, ConfigService> builder;
    private final List<DeferNacosPropertySource> nacosPropertySources = new LinkedList<DeferNacosPropertySource>();

    public NacosConfigLoader(Function<Properties, ConfigService> builder) {
        this.builder = builder;
    }

    public void loadConfig(ConfigurableEnvironment environment, NacosConfigProperties nacosConfigProperties) {
        this.globalProperties = this.buildGlobalNacosProperties(environment, nacosConfigProperties);
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        List<NacosPropertySource> sources = this.reqGlobalNacosConfig(environment, this.globalProperties, nacosConfigProperties);
        for (NacosConfigProperties.Config config : nacosConfigProperties.getExtConfig()) {
            List<NacosPropertySource> elements = this.reqSubNacosConfig(environment, config, this.globalProperties, config.getType());
            sources.addAll(elements);
        }
        if (nacosConfigProperties.isRemoteFirst()) {
            ListIterator<NacosPropertySource> itr = sources.listIterator(sources.size());
            while (itr.hasPrevious()) {
                mutablePropertySources.addAfter("systemEnvironment", (PropertySource)itr.previous());
            }
        } else {
            for (NacosPropertySource propertySource : sources) {
                mutablePropertySources.addLast((PropertySource)propertySource);
            }
        }
    }

    public Properties buildGlobalNacosProperties(ConfigurableEnvironment environment, NacosConfigProperties nacosConfigProperties) {
        return NacosPropertiesBuilder.buildNacosProperties((Environment)environment, nacosConfigProperties.getServerAddr(), nacosConfigProperties.getNamespace(), nacosConfigProperties.getEndpoint(), nacosConfigProperties.getSecretKey(), nacosConfigProperties.getAccessKey(), nacosConfigProperties.getRamRoleName(), nacosConfigProperties.getConfigLongPollTimeout(), nacosConfigProperties.getConfigRetryTime(), nacosConfigProperties.getMaxRetry(), nacosConfigProperties.getContextPath(), nacosConfigProperties.isEnableRemoteSyncConfig(), nacosConfigProperties.getUsername(), nacosConfigProperties.getPassword());
    }

    private Properties buildSubNacosProperties(ConfigurableEnvironment environment, Properties globalProperties, NacosConfigProperties.Config config) {
        Properties sub = NacosPropertiesBuilder.buildNacosProperties((Environment)environment, config.getServerAddr(), config.getNamespace(), config.getEndpoint(), config.getSecretKey(), config.getAccessKey(), config.getRamRoleName(), config.getConfigLongPollTimeout(), config.getConfigRetryTime(), config.getMaxRetry(), null, config.isEnableRemoteSyncConfig(), config.getUsername(), config.getPassword());
        NacosPropertiesBuilder.merge(sub, globalProperties);
        return sub;
    }

    private List<NacosPropertySource> reqGlobalNacosConfig(ConfigurableEnvironment environment, Properties globalProperties, NacosConfigProperties nacosConfigProperties) {
        ArrayList<String> dataIds = new ArrayList<String>();
        if (!StringUtils.hasLength((String)nacosConfigProperties.getDataId())) {
            String ids = environment.resolvePlaceholders(nacosConfigProperties.getDataIds());
            if (StringUtils.hasText((String)ids)) {
                dataIds.addAll(Arrays.asList(ids.split(",")));
            }
        } else {
            dataIds.add(nacosConfigProperties.getDataId());
        }
        String groupName = environment.resolvePlaceholders(nacosConfigProperties.getGroup());
        boolean isAutoRefresh = nacosConfigProperties.isAutoRefresh();
        return new ArrayList<NacosPropertySource>(Arrays.asList(this.reqNacosConfig(environment, globalProperties, dataIds.toArray(new String[0]), groupName, nacosConfigProperties.getType(), isAutoRefresh)));
    }

    private List<NacosPropertySource> reqSubNacosConfig(ConfigurableEnvironment environment, NacosConfigProperties.Config config, Properties globalProperties, ConfigType type) {
        Properties subConfigProperties = this.buildSubNacosProperties(environment, globalProperties, config);
        ArrayList<String> dataIds = new ArrayList<String>();
        if (!StringUtils.hasLength((String)config.getDataId())) {
            String ids = environment.resolvePlaceholders(config.getDataIds());
            dataIds.addAll(Arrays.asList(ids.split(",")));
        } else {
            dataIds.add(config.getDataId());
        }
        String groupName = environment.resolvePlaceholders(config.getGroup());
        boolean isAutoRefresh = config.isAutoRefresh();
        return new ArrayList<NacosPropertySource>(Arrays.asList(this.reqNacosConfig(environment, subConfigProperties, dataIds.toArray(new String[0]), groupName, type, isAutoRefresh)));
    }

    private NacosPropertySource[] reqNacosConfig(ConfigurableEnvironment environment, Properties configProperties, String[] dataIds, String groupId, ConfigType type, boolean isAutoRefresh) {
        NacosPropertySource[] propertySources = new NacosPropertySource[dataIds.length];
        for (int i = 0; i < dataIds.length; ++i) {
            if (!StringUtils.hasLength((String)dataIds[i])) continue;
            String dataId = environment.resolvePlaceholders(dataIds[i].trim());
            String config = NacosUtils.getContent((ConfigService)this.builder.apply(configProperties), (String)dataId, (String)groupId);
            NacosPropertySource nacosPropertySource = new NacosPropertySource(dataId, groupId, NacosUtils.buildDefaultPropertySourceName((String)dataId, (String)groupId, (Map)configProperties), config, type.getType());
            nacosPropertySource.setDataId(dataId);
            nacosPropertySource.setType(type.getType());
            nacosPropertySource.setGroupId(groupId);
            nacosPropertySource.setAutoRefreshed(isAutoRefresh);
            this.logger.info("load config from nacos, data-id is : {}, group is : {}", (Object)nacosPropertySource.getDataId(), (Object)nacosPropertySource.getGroupId());
            propertySources[i] = nacosPropertySource;
            DeferNacosPropertySource defer = new DeferNacosPropertySource(nacosPropertySource, configProperties, environment);
            this.nacosPropertySources.add(defer);
        }
        return propertySources;
    }

    public void addListenerIfAutoRefreshed() {
        this.addListenerIfAutoRefreshed(this.nacosPropertySources);
    }

    public void addListenerIfAutoRefreshed(List<DeferNacosPropertySource> deferNacosPropertySources) {
        for (DeferNacosPropertySource deferNacosPropertySource : deferNacosPropertySources) {
            NacosPropertySourcePostProcessor.addListenerIfAutoRefreshed((NacosPropertySource)deferNacosPropertySource.getNacosPropertySource(), (Properties)deferNacosPropertySource.getProperties(), (ConfigurableEnvironment)deferNacosPropertySource.getEnvironment());
        }
    }

    public List<DeferNacosPropertySource> getNacosPropertySources() {
        return this.nacosPropertySources;
    }

    public Properties getGlobalProperties() {
        return this.globalProperties;
    }

    public static class DeferNacosPropertySource {
        private final NacosPropertySource nacosPropertySource;
        private final ConfigurableEnvironment environment;
        private final Properties properties;

        DeferNacosPropertySource(NacosPropertySource nacosPropertySource, Properties properties, ConfigurableEnvironment environment) {
            this.nacosPropertySource = nacosPropertySource;
            this.properties = properties;
            this.environment = environment;
        }

        NacosPropertySource getNacosPropertySource() {
            return this.nacosPropertySource;
        }

        ConfigurableEnvironment getEnvironment() {
            return this.environment;
        }

        public Properties getProperties() {
            return this.properties;
        }
    }
}

