/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.util;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class NacosPropertiesBuilder {
    public static Properties buildNacosProperties(Environment environment, String serverAddr, String namespaceId, String endpoint, String secretKey, String accessKey, String ramRoleName, String configLongPollTimeout, String configRetryTimeout, String maxRetry, String contextPath, boolean enableRemoteSyncConfig, String username, String password) {
        Properties properties = new Properties();
        NacosPropertiesBuilder.processPropertiesData(properties, environment, serverAddr, "serverAddr");
        NacosPropertiesBuilder.processPropertiesData(properties, environment, namespaceId, "namespace");
        NacosPropertiesBuilder.processPropertiesData(properties, environment, endpoint, "endpoint");
        NacosPropertiesBuilder.processPropertiesData(properties, environment, secretKey, "secretKey");
        NacosPropertiesBuilder.processPropertiesData(properties, environment, accessKey, "accessKey");
        NacosPropertiesBuilder.processPropertiesData(properties, environment, ramRoleName, "ramRoleName");
        NacosPropertiesBuilder.processPropertiesData(properties, environment, configLongPollTimeout, "configLongPollTimeout");
        NacosPropertiesBuilder.processPropertiesData(properties, environment, configRetryTimeout, "configRetryTime");
        NacosPropertiesBuilder.processPropertiesData(properties, environment, contextPath, "contextPath");
        NacosPropertiesBuilder.processPropertiesData(properties, environment, maxRetry, "maxRetry");
        NacosPropertiesBuilder.processPropertiesData(properties, environment, username, "username");
        NacosPropertiesBuilder.processPropertiesData(properties, environment, password, "password");
        properties.put("enableRemoteSyncConfig", String.valueOf(enableRemoteSyncConfig));
        return properties;
    }

    private static void processPropertiesData(Properties properties, Environment environment, String keyword, String key) {
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            properties.put(key, environment.resolvePlaceholders(keyword));
        }
    }

    public static void merge(Properties targetProperties, Properties sourceProperties) {
        if (CollectionUtils.isEmpty((Map)sourceProperties)) {
            return;
        }
        for (Map.Entry<Object, Object> entry : sourceProperties.entrySet()) {
            String propertyName = (String)entry.getKey();
            if (targetProperties.containsKey(propertyName)) continue;
            String propertyValue = (String)entry.getValue();
            targetProperties.setProperty(propertyName, propertyValue);
        }
    }
}

