/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.util.log;

import com.alibaba.boot.nacos.config.properties.NacosConfigProperties;
import com.alibaba.boot.nacos.config.util.NacosConfigLoader;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.AbstractListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.utils.ConcurrentDiskUtil;
import com.alibaba.nacos.client.config.utils.JvmUtil;
import com.alibaba.nacos.client.logging.NacosLogging;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.spring.util.NacosUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import org.slf4j.Logger;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.boot.logging.LoggingSystemFactory;
import org.springframework.core.env.ConfigurableEnvironment;

public class LogAutoFreshProcess {
    private static final Logger LOGGER = LogUtils.logger(LogAutoFreshProcess.class);
    private final NacosConfigProperties nacosConfigProperties;
    private final ConfigurableEnvironment environment;
    private final NacosConfigLoader nacosConfigLoader;
    private final Function<Properties, ConfigService> builder;
    private static final List<String> LOG_DATA_ID = new ArrayList<String>();
    private static final String LOG_CACHE_BASE = System.getProperty("JM.SNAPSHOT.PATH", System.getProperty("user.home")) + File.separator + "nacos" + File.separator + "logConfig";

    public static LogAutoFreshProcess build(ConfigurableEnvironment environment, NacosConfigProperties nacosConfigProperties, NacosConfigLoader nacosConfigLoader, Function<Properties, ConfigService> builder) {
        return new LogAutoFreshProcess(environment, nacosConfigProperties, nacosConfigLoader, builder);
    }

    private LogAutoFreshProcess(ConfigurableEnvironment environment, NacosConfigProperties nacosConfigProperties, NacosConfigLoader nacosConfigLoader, Function<Properties, ConfigService> builder) {
        this.nacosConfigProperties = nacosConfigProperties;
        this.environment = environment;
        this.nacosConfigLoader = nacosConfigLoader;
        this.builder = builder;
    }

    public void process() {
        String groupName = this.environment.resolvePlaceholders(this.nacosConfigProperties.getGroup());
        ConfigService configService = this.builder.apply(this.nacosConfigLoader.getGlobalProperties());
        for (String dataId : LOG_DATA_ID) {
            String content = NacosUtils.getContent((ConfigService)configService, (String)dataId, (String)groupName);
            if (!StringUtils.isNotBlank((String)content)) continue;
            this.writeLogFile(content, dataId);
            System.setProperty("logging.config", LOG_CACHE_BASE + File.separator + dataId);
            this.registerListener(configService, dataId, groupName);
            return;
        }
    }

    private void registerListener(ConfigService configService, final String dataId, String groupName) {
        try {
            configService.addListener(dataId, groupName, (Listener)new AbstractListener(){

                public void receiveConfigInfo(String configInfo) {
                    if (StringUtils.isNotBlank((String)configInfo)) {
                        LogAutoFreshProcess.this.writeLogFile(configInfo, dataId);
                        LogAutoFreshProcess.this.reloadConfig(LOG_CACHE_BASE + File.separator + dataId);
                    }
                }
            });
        }
        catch (NacosException e) {
            throw new RuntimeException("ConfigService can't add Listener with dataId : " + dataId, e);
        }
    }

    private void writeLogFile(String content, String dataId) {
        boolean isMdOk;
        File file = new File(LOG_CACHE_BASE, dataId);
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !(isMdOk = parentFile.mkdirs())) {
            LOGGER.error("save log cache error");
        }
        try {
            if (JvmUtil.isMultiInstance().booleanValue()) {
                ConcurrentDiskUtil.writeFileContent((File)file, (String)content, (String)"UTF-8");
            } else {
                IoUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("write log file fail");
        }
    }

    private void reloadConfig(String logPath) {
        LoggingSystem loggingSystem = LoggingSystemFactory.fromSpringFactories().getLoggingSystem(this.getClass().getClassLoader());
        loggingSystem.cleanUp();
        loggingSystem.initialize(new LoggingInitializationContext(this.environment), logPath, null);
        NacosLogging.getInstance().loadConfiguration();
    }

    static {
        LOG_DATA_ID.add("logback.xml");
        LOG_DATA_ID.add("log4j2.xml");
    }
}

