/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.aot.context;

import com.alibaba.boot.nacos.aot.util.AotDetector;
import com.alibaba.nacos.spring.context.annotation.config.NacosPropertySource;
import com.alibaba.nacos.spring.core.env.AbstractNacosPropertySourceBuilder;
import com.alibaba.nacos.spring.core.env.NacosPropertySourcePostProcessor;
import com.alibaba.nacos.spring.util.NacosBeanUtils;
import com.alibaba.spring.util.BeanUtils;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class NacosPropertySourcePostProcessorForAot
extends NacosPropertySourcePostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanNames;
        String[] abstractNacosPropertySourceBuilderBeanNames = BeanUtils.getBeanNames((ConfigurableListableBeanFactory)beanFactory, AbstractNacosPropertySourceBuilder.class);
        this.nacosPropertySourceBuilders = new ArrayList(abstractNacosPropertySourceBuilderBeanNames.length);
        for (String beanName : abstractNacosPropertySourceBuilderBeanNames) {
            this.nacosPropertySourceBuilders.add((AbstractNacosPropertySourceBuilder)beanFactory.getBean(beanName, AbstractNacosPropertySourceBuilder.class));
        }
        NacosPropertySourcePostProcessor.beanFactory = beanFactory;
        this.configServiceBeanBuilder = NacosBeanUtils.getConfigServiceBeanBuilder((BeanFactory)beanFactory);
        if (AotDetector.useGeneratedArtifacts()) {
            Map beansWithAnnotation = beanFactory.getBeansWithAnnotation(NacosPropertySource.class);
            for (Map.Entry entry : beansWithAnnotation.entrySet()) {
                this.processPropertySourceForAot((String)entry.getKey(), entry.getValue());
            }
        }
        for (String beanName : beanNames = beanFactory.getBeanDefinitionNames()) {
            this.processPropertySource(beanName, beanFactory);
        }
    }

    private void processPropertySourceForAot(String beanName, Object bean) {
        if (this.processedBeanNames.contains(beanName)) {
            return;
        }
        AnnotatedGenericBeanDefinition beanDefinition = null;
        Class<?> aClass = bean.getClass();
        NacosPropertySource[] annotations = (NacosPropertySource[])aClass.getSuperclass().getAnnotationsByType(NacosPropertySource.class);
        if (annotations.length != 0) {
            beanDefinition = new AnnotatedGenericBeanDefinition(aClass.getSuperclass());
        }
        if ((annotations = (NacosPropertySource[])aClass.getAnnotationsByType(NacosPropertySource.class)).length != 0) {
            beanDefinition = new AnnotatedGenericBeanDefinition(aClass);
        }
        this.doProcessPropertySource(beanName, (BeanDefinition)beanDefinition);
        this.processedBeanNames.add(beanName);
    }
}

