/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.aot.hint;

import com.alibaba.nacos.api.annotation.NacosInjected;
import com.alibaba.nacos.api.config.annotation.NacosValue;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.util.ReflectionUtils;

public class NacosAnnotationBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class beanClass = registeredBean.getBeanClass();
        ArrayList<Field> fields = new ArrayList<Field>();
        ReflectionUtils.doWithFields((Class)beanClass, field -> {
            NacosInjected injectedAnnotation = field.getDeclaredAnnotation(NacosInjected.class);
            NacosValue nacosValueAnnotation = field.getDeclaredAnnotation(NacosValue.class);
            if (injectedAnnotation != null || nacosValueAnnotation != null) {
                fields.add(field);
            }
        });
        if (fields.isEmpty()) {
            return null;
        }
        return new AotContribution(fields);
    }

    private static class AotContribution
    implements BeanRegistrationAotContribution {
        private final List<Field> fields;

        public AotContribution() {
            this.fields = new ArrayList<Field>();
        }

        public AotContribution(List<Field> fields) {
            this.fields = fields;
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            for (Field field : this.fields) {
                generationContext.getRuntimeHints().reflection().registerField(field);
            }
        }
    }
}

