/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.autoconfigure;

import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import com.alicp.jetcache.anno.support.SpringConfigProvider;
import com.alicp.jetcache.autoconfigure.AutoConfigureBeans;
import com.alicp.jetcache.autoconfigure.BeanDependencyManager;
import com.alicp.jetcache.autoconfigure.CaffeineAutoConfiguration;
import com.alicp.jetcache.autoconfigure.JetCacheProperties;
import com.alicp.jetcache.autoconfigure.LinkedHashMapAutoConfiguration;
import com.alicp.jetcache.autoconfigure.MockRemoteCacheAutoConfiguration;
import com.alicp.jetcache.autoconfigure.RedisAutoConfiguration;
import com.alicp.jetcache.autoconfigure.RedisLettuceAutoConfiguration;
import com.alicp.jetcache.autoconfigure.RedisSpringDataAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={GlobalCacheConfig.class})
@ConditionalOnMissingBean(value={GlobalCacheConfig.class})
@EnableConfigurationProperties(value={JetCacheProperties.class})
@Import(value={RedisAutoConfiguration.class, CaffeineAutoConfiguration.class, MockRemoteCacheAutoConfiguration.class, LinkedHashMapAutoConfiguration.class, RedisLettuceAutoConfiguration.class, RedisSpringDataAutoConfiguration.class})
public class JetCacheAutoConfiguration {
    public static final String GLOBAL_CACHE_CONFIG_NAME = "globalCacheConfig";
    private SpringConfigProvider _springConfigProvider = new SpringConfigProvider();
    private AutoConfigureBeans _autoConfigureBeans = new AutoConfigureBeans();
    private GlobalCacheConfig _globalCacheConfig;

    @Bean
    @ConditionalOnMissingBean
    public SpringConfigProvider springConfigProvider() {
        return this._springConfigProvider;
    }

    @Bean
    public AutoConfigureBeans autoConfigureBeans() {
        return this._autoConfigureBeans;
    }

    @Bean
    public static BeanDependencyManager beanDependencyManager() {
        return new BeanDependencyManager();
    }

    @Bean(name={"globalCacheConfig"})
    public GlobalCacheConfig globalCacheConfig(SpringConfigProvider configProvider, AutoConfigureBeans autoConfigureBeans, JetCacheProperties props) {
        if (this._globalCacheConfig != null) {
            return this._globalCacheConfig;
        }
        this._globalCacheConfig = new GlobalCacheConfig();
        this._globalCacheConfig.setHiddenPackages(props.getHiddenPackages());
        this._globalCacheConfig.setStatIntervalMinutes(props.getStatIntervalMinutes());
        this._globalCacheConfig.setAreaInCacheName(props.isAreaInCacheName());
        this._globalCacheConfig.setPenetrationProtect(props.isPenetrationProtect());
        this._globalCacheConfig.setEnableMethodCache(props.isEnableMethodCache());
        this._globalCacheConfig.setLocalCacheBuilders(autoConfigureBeans.getLocalCacheBuilders());
        this._globalCacheConfig.setRemoteCacheBuilders(autoConfigureBeans.getRemoteCacheBuilders());
        return this._globalCacheConfig;
    }
}

