/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.conditions;

import com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.properties.AadApplicationType;
import com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.properties.AadAuthenticationProperties;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public final class ClientRegistrationCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)"AAD Application Client Condition", (Object[])new Object[0]);
        AadAuthenticationProperties properties = (AadAuthenticationProperties)Binder.get((Environment)context.getEnvironment()).bind("spring.cloud.azure.active-directory", AadAuthenticationProperties.class).orElse(null);
        if (properties == null) {
            return ConditionOutcome.noMatch((ConditionMessage)message.notAvailable("AAD authorization properties(spring.cloud.azure.active-directory.xxx)"));
        }
        AadApplicationType applicationType = Optional.ofNullable(properties.getApplicationType()).orElseGet(AadApplicationType::inferApplicationTypeByDependencies);
        if (applicationType == null || applicationType == AadApplicationType.RESOURCE_SERVER) {
            return ConditionOutcome.noMatch((ConditionMessage)message.because("Resource server does not need client registration."));
        }
        return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)("spring.cloud.azure.active-directory.application-type=" + String.valueOf((Object)applicationType))));
    }
}

