/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.connectionstring;

import com.azure.spring.cloud.core.implementation.connectionstring.ConnectionString;
import com.azure.spring.cloud.core.implementation.connectionstring.ConnectionStringType;
import java.net.URI;

public class EventHubsConnectionString {
    private final URI endpointUri;
    private final String endpoint;
    private final String entityPath;
    private final String sharedAccessKeyName;
    private final String sharedAccessKey;

    public EventHubsConnectionString(String str) {
        ConnectionString connectionString = new ConnectionString(str, ConnectionStringType.EVENT_HUB);
        this.endpointUri = connectionString.getEndpointUri();
        this.endpoint = connectionString.getSegment("Endpoint");
        this.entityPath = connectionString.getSegment("EntityPath");
        this.sharedAccessKeyName = connectionString.getSegment("SharedAccessKeyName");
        this.sharedAccessKey = connectionString.getSegment("SharedAccessKey");
    }

    public String getEntityPath() {
        return this.entityPath;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public URI getEndpointUri() {
        return this.endpointUri;
    }

    public String getFullyQualifiedNamespace() {
        return this.endpointUri.getHost();
    }

    public String getSharedAccessKeyName() {
        return this.sharedAccessKeyName;
    }

    public String getSharedAccessKey() {
        return this.sharedAccessKey;
    }
}

