/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.converter;

import com.azure.core.amqp.ProxyAuthenticationType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.spring.cloud.core.provider.ProxyOptionsProvider;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.StringUtils;

public final class AzureAmqpProxyOptionsConverter
implements Converter<ProxyOptionsProvider.AmqpProxyOptions, ProxyOptions> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureAmqpProxyOptionsConverter.class);
    public static final AzureAmqpProxyOptionsConverter AMQP_PROXY_CONVERTER = new AzureAmqpProxyOptionsConverter();

    private AzureAmqpProxyOptionsConverter() {
    }

    public ProxyOptions convert(ProxyOptionsProvider.AmqpProxyOptions proxy) {
        if (!StringUtils.hasText((String)proxy.getHostname()) || proxy.getPort() == null) {
            LOGGER.debug("Proxy hostname or port is not set.");
            return null;
        }
        if (proxy.getType() == null) {
            throw new IllegalArgumentException("Wrong proxy type provided!");
        }
        ProxyAuthenticationType authenticationType = ProxyAuthenticationType.NONE;
        if (proxy.getAuthenticationType() != null) {
            switch (proxy.getAuthenticationType().toLowerCase(Locale.ROOT)) {
                case "basic": {
                    authenticationType = ProxyAuthenticationType.BASIC;
                    break;
                }
                case "digest": {
                    authenticationType = ProxyAuthenticationType.DIGEST;
                    break;
                }
            }
        }
        Proxy proxyAddress = new Proxy(switch (proxy.getType()) {
            case "http" -> Proxy.Type.HTTP;
            case "socks" -> Proxy.Type.SOCKS;
            default -> throw new IllegalArgumentException("Wrong proxy type provided!");
        }, new InetSocketAddress(proxy.getHostname(), (int)proxy.getPort()));
        return new ProxyOptions(authenticationType, proxyAddress, proxy.getUsername(), proxy.getPassword());
    }
}

