/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public final class ClassUtils {
    private static final Map<Class<?>, Function<Object, Boolean>> PRIMITIVE_DEFAULT_VALUE_CHECKER = new HashMap(8);

    private ClassUtils() {
    }

    public static boolean isPrimitiveDefaultValue(Class<?> type, Object value) {
        return PRIMITIVE_DEFAULT_VALUE_CHECKER.containsKey(type) && PRIMITIVE_DEFAULT_VALUE_CHECKER.get(type).apply(value) != false;
    }

    public static boolean isPrimitiveNonDefaultValue(Class<?> type, Object value) {
        return PRIMITIVE_DEFAULT_VALUE_CHECKER.containsKey(type) && PRIMITIVE_DEFAULT_VALUE_CHECKER.get(type).apply(value) == false;
    }

    public static boolean isPrimitive(Class<?> type) {
        return PRIMITIVE_DEFAULT_VALUE_CHECKER.containsKey(type);
    }

    static {
        PRIMITIVE_DEFAULT_VALUE_CHECKER.put(Boolean.TYPE, v -> (Boolean)v == false);
        PRIMITIVE_DEFAULT_VALUE_CHECKER.put(Byte.TYPE, v -> (Byte)v == 0);
        PRIMITIVE_DEFAULT_VALUE_CHECKER.put(Character.TYPE, v -> ((Character)v).charValue() == '\u0000');
        PRIMITIVE_DEFAULT_VALUE_CHECKER.put(Short.TYPE, v -> (Short)v == 0);
        PRIMITIVE_DEFAULT_VALUE_CHECKER.put(Integer.TYPE, v -> (Integer)v == 0);
        PRIMITIVE_DEFAULT_VALUE_CHECKER.put(Long.TYPE, v -> (Long)v == 0L);
        PRIMITIVE_DEFAULT_VALUE_CHECKER.put(Double.TYPE, v -> (Double)v == 0.0);
        PRIMITIVE_DEFAULT_VALUE_CHECKER.put(Float.TYPE, v -> ((Float)v).floatValue() == 0.0f);
    }
}

