/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.internal;

import com.clickhouse.client.api.internal.StopWatch;
import com.clickhouse.client.api.metrics.ClientMetrics;
import java.util.HashMap;
import java.util.Map;

public class ClientStatisticsHolder {
    private final Map<String, StopWatch> stopWatches = new HashMap<String, StopWatch>();

    public void start(ClientMetrics metric) {
        this.start(metric.getKey());
    }

    public void start(String spanName) {
        this.stopWatches.computeIfAbsent(spanName, k -> new StopWatch()).start();
    }

    public StopWatch stop(ClientMetrics metric) {
        return this.stop(metric.getKey());
    }

    public StopWatch stop(String spanName) {
        StopWatch timer = this.stopWatches.computeIfAbsent(spanName, k -> new StopWatch());
        timer.stop();
        return timer;
    }

    public long getElapsedTime(String spanName) {
        StopWatch sw = this.stopWatches.get(spanName);
        return sw == null ? -1L : sw.getElapsedTime();
    }

    public Map<String, StopWatch> getStopWatches() {
        return this.stopWatches;
    }

    public String toString() {
        return "ClientStatistics{\"spans\"=" + this.stopWatches + '}';
    }
}

