/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseDataConfig;
import com.clickhouse.data.ClickHouseDeferredValue;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.ClickHouseUtils;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

@Deprecated
public class ClickHouseExternalTable
implements Serializable {
    private static final long serialVersionUID = -5395148151046691946L;
    public static final String TYPE_NAME = "ExternalTable";
    private final String name;
    private final ClickHouseDeferredValue<InputStream> content;
    private final ClickHouseCompression compression;
    private final int compressionLevel;
    private final ClickHouseFormat format;
    private final List<ClickHouseColumn> columns;
    private final boolean asTempTable;
    private final String structure;

    public static Builder builder() {
        return new Builder();
    }

    protected ClickHouseExternalTable(String name, ClickHouseDeferredValue<InputStream> content, ClickHouseCompression compression, int compressionLevel, ClickHouseFormat format, Collection<ClickHouseColumn> columns, boolean asTempTable) {
        int size;
        String string = this.name = name == null ? "" : name.trim();
        this.compression = compression == null ? ((compression = ClickHouseCompression.fromFileName(this.name)) == null ? ClickHouseCompression.NONE : compression) : compression;
        this.compressionLevel = compressionLevel;
        ClickHouseFormat clickHouseFormat = this.format = format == null ? ClickHouseFormat.TabSeparated : format;
        if (content == null) {
            throw new IllegalArgumentException("Non-null content is required");
        }
        this.content = compression == ClickHouseCompression.NONE ? content : ClickHouseDeferredValue.of(() -> ClickHouseInputStream.of((InputStream)content.get(), ClickHouseDataConfig.getDefaultReadBufferSize(), this.compression, this.compressionLevel, null));
        int n = size = columns == null ? 0 : columns.size();
        if (size == 0) {
            this.columns = Collections.emptyList();
            this.structure = "";
        } else {
            StringBuilder builder = new StringBuilder();
            ArrayList<ClickHouseColumn> list = new ArrayList<ClickHouseColumn>(size);
            for (ClickHouseColumn c : columns) {
                list.add(c);
                builder.append(c.getColumnName()).append(' ').append(c.getOriginalTypeName()).append(',');
            }
            this.columns = Collections.unmodifiableList(list);
            this.structure = builder.deleteCharAt(builder.length() - 1).toString();
        }
        this.asTempTable = asTempTable;
    }

    public boolean hasName() {
        return !this.name.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public InputStream getContent() {
        return this.content.get();
    }

    public ClickHouseCompression getCompression() {
        return this.compression;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public ClickHouseFormat getFormat() {
        return this.format;
    }

    public List<ClickHouseColumn> getColumns() {
        return this.columns;
    }

    public boolean isTempTable() {
        return this.asTempTable;
    }

    public String getStructure() {
        return this.structure;
    }

    public static class Builder {
        private String name;
        private ClickHouseDeferredValue<InputStream> content;
        private ClickHouseCompression compression;
        private int compressionLevel = -1;
        private ClickHouseFormat format;
        private List<ClickHouseColumn> columns = new LinkedList<ClickHouseColumn>();
        private boolean asTempTable;

        protected Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder compression(ClickHouseCompression compression) {
            return this.compression(compression, -1);
        }

        public Builder compression(ClickHouseCompression compression, int compressionLevel) {
            this.compression = compression;
            this.compressionLevel = compressionLevel;
            return this;
        }

        public Builder content(ClickHousePassThruStream stream) {
            if (stream == null || !stream.hasInput()) {
                throw new IllegalArgumentException("Non-null pass-thru stream with input is required");
            }
            this.compression = ClickHouseCompression.NONE;
            this.compressionLevel = -1;
            this.content = ClickHouseDeferredValue.of(stream.getInputStream(), InputStream.class);
            if (stream.hasFormat()) {
                this.format = stream.getFormat();
            }
            return this;
        }

        public Builder content(InputStream content) {
            if (ClickHouseChecker.nonNull(content, "content") instanceof ClickHouseInputStream) {
                return this.content((ClickHouseInputStream)content);
            }
            this.content = ClickHouseDeferredValue.of(content, InputStream.class);
            return this;
        }

        public Builder content(ClickHouseInputStream input) {
            if (ClickHouseChecker.nonNull(input, "InputStream").hasUnderlyingStream()) {
                ClickHousePassThruStream stream = input.getUnderlyingStream();
                this.compression = ClickHouseCompression.NONE;
                this.compressionLevel = -1;
                this.content = ClickHouseDeferredValue.of(stream.getInputStream(), InputStream.class);
            } else {
                this.content = ClickHouseDeferredValue.of(input, InputStream.class);
            }
            return this;
        }

        public Builder content(ClickHouseDeferredValue<InputStream> content) {
            this.content = ClickHouseChecker.nonNull(content, "Content");
            return this;
        }

        public Builder content(String file) {
            String fileName = ClickHouseChecker.nonEmpty(file, "File");
            this.content = ClickHouseDeferredValue.of(() -> {
                try {
                    return ClickHouseUtils.getFileInputStream(fileName);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            });
            return this;
        }

        public Builder format(String format) {
            if (!ClickHouseChecker.isNullOrBlank(format)) {
                this.format = ClickHouseFormat.valueOf(format);
            }
            return this;
        }

        public Builder format(ClickHouseFormat format) {
            this.format = format;
            return this;
        }

        public Builder addColumn(String name, String type) {
            this.columns.add(ClickHouseColumn.of(name, type));
            return this;
        }

        public Builder removeColumn(String name) {
            Iterator<ClickHouseColumn> iterator = this.columns.iterator();
            while (iterator.hasNext()) {
                ClickHouseColumn c = iterator.next();
                if (!c.getColumnName().equals(name)) continue;
                iterator.remove();
            }
            return this;
        }

        public Builder removeColumn(ClickHouseColumn column) {
            this.columns.remove(column);
            return this;
        }

        public Builder columns(String columns) {
            return !ClickHouseChecker.isNullOrBlank(columns) ? this.columns(ClickHouseColumn.parse(columns)) : this;
        }

        public Builder columns(Collection<ClickHouseColumn> columns) {
            if (columns != null) {
                for (ClickHouseColumn c : columns) {
                    this.columns.add(c);
                }
            }
            return this;
        }

        public Builder asTempTable() {
            this.asTempTable = true;
            return this;
        }

        public Builder asExternalTable() {
            this.asTempTable = false;
            return this;
        }

        public ClickHouseExternalTable build() {
            return new ClickHouseExternalTable(this.name, this.content, this.compression, this.compressionLevel, this.format, this.columns, this.asTempTable);
        }
    }
}

