/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.base;

import com.diffplug.common.base.Unhandled;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public enum Comparison {
    LESSER,
    EQUAL,
    GREATER;


    @CheckReturnValue
    @Nullable
    public <T> T lesserEqualGreater(@Nullable T lesser, @Nullable T equal, @Nullable T greater) {
        switch (this) {
            case LESSER: {
                return lesser;
            }
            case EQUAL: {
                return equal;
            }
            case GREATER: {
                return greater;
            }
        }
        throw Unhandled.enumException(this);
    }

    @CheckReturnValue
    public static <T extends Comparable<T>> Comparison compare(T a, T b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        return Comparison.from(a.compareTo(b));
    }

    @CheckReturnValue
    public static <T> Comparison compare(Comparator<T> comparator, @Nullable T a, @Nullable T b) {
        return Comparison.from(comparator.compare(a, b));
    }

    @CheckReturnValue
    @SuppressFBWarnings(value={"UC_USELESS_CONDITION"}, justification="Throwing Unhandled keeps the full-enumeration more explicit.")
    public static Comparison from(int compareToResult) {
        if (compareToResult == 0) {
            return EQUAL;
        }
        if (compareToResult < 0) {
            return LESSER;
        }
        if (compareToResult > 0) {
            return GREATER;
        }
        throw Unhandled.integerException(compareToResult);
    }
}

