/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.config;

import com.anwen.mongo.execute.SqlExecute;
import com.anwen.mongo.service.IService;
import com.anwen.mongo.service.impl.ServiceImpl;
import com.anwen.mongo.strategy.convert.ConversionService;
import com.anwen.mongo.strategy.convert.ConversionStrategy;
import com.mongodb.MongoException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;

public class MongoPlusAutoConfiguration
implements InitializingBean {
    private final SqlExecute sqlExecute;
    private final ApplicationContext applicationContext;
    Logger logger = LoggerFactory.getLogger(MongoPlusAutoConfiguration.class);

    public MongoPlusAutoConfiguration(SqlExecute sqlExecute, ApplicationContext applicationContext) {
        this.sqlExecute = sqlExecute;
        this.applicationContext = applicationContext;
        this.setConversion();
    }

    public void afterPropertiesSet() {
        this.applicationContext.getBeansOfType(IService.class).values().stream().filter(s -> s instanceof ServiceImpl).forEach(s -> this.setSqlExecute((ServiceImpl)s, s.getGenericityClazz()));
    }

    private void setSqlExecute(ServiceImpl<?> serviceImpl, Class<?> clazz) {
        this.sqlExecute.init(clazz);
        serviceImpl.setClazz(clazz);
        serviceImpl.setSqlOperation(this.sqlExecute);
    }

    private void setConversion() {
        this.applicationContext.getBeansOfType(ConversionStrategy.class).values().forEach(conversionStrategy -> {
            try {
                Type[] genericInterfaces;
                for (Type anInterface : genericInterfaces = conversionStrategy.getClass().getGenericInterfaces()) {
                    ParameterizedType parameterizedType = (ParameterizedType)anInterface;
                    if (!parameterizedType.getRawType().equals(ConversionStrategy.class)) continue;
                    Class clazz = (Class)parameterizedType.getActualTypeArguments()[0];
                    ConversionService.appendConversion((Class)clazz, (ConversionStrategy)conversionStrategy);
                    break;
                }
            }
            catch (Exception e) {
                this.logger.error("Unknown converter type", (Throwable)e);
                throw new MongoException("Unknown converter type");
            }
        });
    }
}

