/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.config;

import com.anwen.mongo.cache.MongoClientCache;
import com.anwen.mongo.convert.CollectionNameConvert;
import com.anwen.mongo.enums.CollectionNameConvertEnum;
import com.anwen.mongo.execute.SqlExecute;
import com.anwen.mongo.log.CustomMongoDriverLogger;
import com.anwen.mongo.mapper.MongoPlusMapMapper;
import com.anwen.mongo.model.BaseProperty;
import com.anwen.mongo.property.MongoDBCollectionProperty;
import com.anwen.mongo.property.MongoDBConnectProperty;
import com.anwen.mongo.property.MongoDBLogProperty;
import com.anwen.mongo.toolkit.MongoCollectionUtils;
import com.anwen.mongo.toolkit.UrlJoint;
import com.anwen.mongo.transactional.MongoTransactionalAspect;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.event.CommandListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;

@EnableConfigurationProperties(value={MongoDBConnectProperty.class, MongoDBLogProperty.class, MongoDBCollectionProperty.class})
public class MongoPlusConfiguration {
    private final MongoDBLogProperty mongoDBLogProperty;
    private final MongoDBConnectProperty mongoDBConnectProperty;
    private final MongoDBCollectionProperty mongoDBCollectionProperty;
    private MongoClient mongoClient;
    private SqlExecute sqlExecute;

    public SqlExecute getSqlExecute() {
        return this.sqlExecute;
    }

    public MongoPlusConfiguration(MongoDBConnectProperty mongoDBConnectProperty, MongoDBLogProperty mongoDBLogProperty, MongoDBCollectionProperty mongoDBCollectionProperty) {
        this.mongoDBConnectProperty = mongoDBConnectProperty;
        this.mongoDBLogProperty = mongoDBLogProperty;
        this.mongoDBCollectionProperty = mongoDBCollectionProperty;
    }

    @Bean(value={"sqlExecute"})
    @ConditionalOnMissingBean
    public SqlExecute sqlExecute() {
        if (this.sqlExecute != null) {
            return this.sqlExecute;
        }
        SqlExecute sqlExecute = new SqlExecute();
        sqlExecute.setSlaveDataSources(this.mongoDBConnectProperty.getSlaveDataSource());
        sqlExecute.setBaseProperty((BaseProperty)this.mongoDBConnectProperty);
        CollectionNameConvert collectionNameConvert = MongoCollectionUtils.build((CollectionNameConvertEnum)this.mongoDBCollectionProperty.getMappingStrategy());
        sqlExecute.setCollectionNameConvert(collectionNameConvert);
        UrlJoint urlJoint = new UrlJoint((BaseProperty)this.mongoDBConnectProperty);
        MongoClientSettings.Builder builder = MongoClientSettings.builder().applyConnectionString(new ConnectionString(urlJoint.jointMongoUrl()));
        if (this.mongoDBLogProperty.getLog().booleanValue()) {
            builder.addCommandListener((CommandListener)new CustomMongoDriverLogger(this.mongoDBLogProperty.getFormat()));
        }
        this.mongoClient = MongoClients.create((MongoClientSettings)builder.build());
        sqlExecute.setMongoClient(this.mongoClient);
        this.sqlExecute = sqlExecute;
        return sqlExecute;
    }

    @Bean(value={"mongo"})
    @ConditionalOnMissingBean
    @DependsOn(value={"sqlExecute"})
    public MongoClient mongo() {
        MongoClientCache.mongoClient = this.mongoClient;
        return this.mongoClient;
    }

    @Bean(value={"mongoPlusMapMapper"})
    @ConditionalOnMissingBean
    public MongoPlusMapMapper mongoPlusMapMapper(SqlExecute sqlExecute) {
        return new MongoPlusMapMapper(sqlExecute);
    }

    @Bean(value={"mongoTransactionalAspect"})
    @Deprecated
    @ConditionalOnMissingBean
    public MongoTransactionalAspect mongoTransactionalAspect() {
        return new MongoTransactionalAspect(this.mongoClient);
    }
}

