/*
 * Decompiled with CFR 0.152.
 */
package com.anwen.mongo.transactional;

import com.anwen.mongo.context.MongoTransactionSpring;
import com.mongodb.ClientSessionOptions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class MongoPlusTransactionalManager
extends AbstractPlatformTransactionManager {
    Logger logger = LoggerFactory.getLogger(MongoPlusTransactionalManager.class);
    private final MongoClient mongoClient;

    public MongoPlusTransactionalManager(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    protected Object doGetTransaction() throws TransactionException {
        return this.mongoClient.startSession(ClientSessionOptions.builder().causallyConsistent(true).build());
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        ClientSession clientSession = (ClientSession)transaction;
        TransactionSynchronizationManager.bindResource((Object)Objects.requireNonNull(definition.getName()), (Object)clientSession);
        clientSession.startTransaction();
        MongoTransactionSpring.setResources((Map)TransactionSynchronizationManager.getResourceMap());
        MongoTransactionSpring.setCurrentTransactionName((String)definition.getName());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("begin transaction -> name: {} , sessionId: {}", (Object)definition.getName(), (Object)clientSession.getServerSession().getIdentifier());
        }
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        ClientSession clientSession = (ClientSession)status.getTransaction();
        if (clientSession.hasActiveTransaction()) {
            clientSession.commitTransaction();
            clientSession.close();
        }
        MongoTransactionSpring.clear();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("commit transaction -> sessionId: {}", (Object)clientSession.getServerSession().getIdentifier());
        }
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        ClientSession clientSession = (ClientSession)status.getTransaction();
        if (clientSession.hasActiveTransaction()) {
            clientSession.abortTransaction();
            clientSession.close();
        }
        MongoTransactionSpring.clear();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("rollback transaction");
        }
    }
}

